/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.oidc.avatar.importer.libravatar;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarDefaultImage;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.ParameterName;

public class LibravatarOptions {
    private static String baseUri = "http://cdn.libravatar.org/avatar/";
    private static String secureBaseUri = "https://seccdn.libravatar.org/avatar/";
    private boolean useHttps;
    private boolean useSHA256;
    private LibravatarDefaultImage defaultImage;
    private Integer imageSize;
    private boolean forceDefault;

    public LibravatarOptions withHttps() {
        this.useHttps = true;
        return this;
    }

    public LibravatarOptions useSHA256() {
        this.useSHA256 = true;
        return this;
    }

    public LibravatarOptions withImageSize(Integer imageSize) {
        Preconditions.checkArgument((imageSize >= 1 && imageSize <= 512 ? 1 : 0) != 0);
        this.imageSize = imageSize;
        return this;
    }

    public LibravatarOptions withoutHttps() {
        this.useHttps = false;
        return this;
    }

    public LibravatarOptions defaultingTo(LibravatarDefaultImage defaultImage) {
        this.defaultImage = defaultImage;
        return this;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public boolean isUseSHA256() {
        return this.useSHA256;
    }

    public Boolean hasDefaultImageSet() {
        return this.defaultImage != null;
    }

    public LibravatarDefaultImage getDefaultImage() {
        return this.defaultImage;
    }

    public Boolean hasImageSizeSet() {
        return this.imageSize != null;
    }

    public Integer getImageSize() {
        return this.imageSize;
    }

    public boolean isForceDefault() {
        return this.forceDefault;
    }

    public Map<String, String> toParametersMap() {
        return this.toParametersMap(false);
    }

    public Map<String, String> toParametersMap(boolean useLongNames) {
        ParameterName p;
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        if (this.hasImageSizeSet().booleanValue()) {
            p = ParameterName.SIZE;
            parametersMap.put(useLongNames ? p.getName() : p.getShortName(), String.valueOf(this.getImageSize()));
        }
        if (this.hasDefaultImageSet().booleanValue()) {
            p = ParameterName.DEFAULT;
            parametersMap.put(useLongNames ? p.getName() : p.getShortName(), this.getDefaultImage().getCode());
        }
        if (this.isForceDefault()) {
            p = ParameterName.FORCE_DEFAULT;
            parametersMap.put(useLongNames ? p.getName() : p.getShortName(), "y");
        }
        return parametersMap;
    }

    public static void setBaseUri(String baseUri) {
        LibravatarOptions.baseUri = baseUri;
    }

    public static String getBaseUri() {
        return baseUri;
    }

    public static void setSecureBaseUri(String secureBaseUri) {
        LibravatarOptions.secureBaseUri = secureBaseUri;
    }

    public static String getSecureBaseUri() {
        return secureBaseUri;
    }
}

