/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar.storage.s3;

import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.avatar.storage.AvatarStorageProviderFactory;
import org.gcube.keycloak.avatar.storage.s3.MinioAvatarStorageProvider;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class MinioAvatarStorageProviderFactory
implements AvatarStorageProviderFactory {
    private MinioAvatarStorageProvider.Configuration minioConfig;

    public AvatarStorageProvider create(KeycloakSession session) {
        return new MinioAvatarStorageProvider(this.minioConfig);
    }

    public void init(Config.Scope config) {
        String serverUrl = config.get("server-url");
        String accessKey = config.get("access-key");
        String secretKey = config.get("secret-key");
        String rootBucket = config.get("root-bucket");
        this.minioConfig = new MinioAvatarStorageProvider.Configuration(serverUrl, accessKey, secretKey, rootBucket);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "avatar-storage-s3";
    }
}

