package org.gcube.keycloak.protocol.oidc;

import org.gcube.keycloak.protocol.oidc.EOSCNodeAccessTokenIntrospectionProvider.Configuration;
import org.jboss.logging.Logger;
import org.keycloak.Config.Scope;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProviderFactory;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;

/**
 * @author <a href="mailto:mauro.mugnaini@nubisware.com">Mauro Mugnaini</a>
 */
public class AccessTokenIntrospectionProviderOverrideDefaultWithEOSCNodeFactory
        extends AccessTokenIntrospectionProviderFactory {

    private static final Logger logger = Logger
            .getLogger(AccessTokenIntrospectionProviderOverrideDefaultWithEOSCNodeFactory.class);

    protected Configuration eoscNodeConfiguration;

    @Override
    public int order() {
        // to be sure that the order is higher than the default
        return super.order() + 1;
    }

    @Override
    public void init(Scope config) {
        this.eoscNodeConfiguration = new Configuration(config);
        if (!this.eoscNodeConfiguration.isConfigured()) {
            logger.warn("Provider factory is not configured properly, it will act as normal introspection endpoint");
        }
    }

    @Override
    public TokenIntrospectionProvider create(KeycloakSession session) {
        return new EOSCNodeAccessTokenIntrospectionProvider(session, eoscNodeConfiguration); // <AccessToken>
    }

}
