/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.broker.oidc.mappers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class UsernameFromMailMapper
extends AbstractClaimMapper {
    private static final Logger logger = Logger.getLogger(UsernameFromMailMapper.class);
    private static final Character PERIOD = Character.valueOf('.');
    private static final Character DASH = Character.valueOf('-');
    private static final String CYRUS = "cyrus";
    private static final String POSTFIX = "postfix";
    private static final String COMMA = ",";
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"oidc", "bitbucket", "facebook", "keycloak-oidc", "github", "gitlab", "google", "instagram", "linkedin", "microsoft", "openshift-v3", "openshift-v4", "paypal", "stackoverflow", "twitter"};
    private static final List<ProviderConfigProperty> configProperties;
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES;
    public static final String RESERVED_USERNAMES = "reserved-usernames";
    public static final String AUTO_RESOLVE_CONFLICT = "auto-resolve";
    public static final String PROVIDER_ID = "username-from-idp-email-mapper";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Username from IdP email importer";
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        if (!realm.isRegistrationEmailAsUsername()) {
            user.setUsername(context.getModelUsername());
        }
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        Set<String> reservedUsernames = this.getConfigValuesOrEmptySetIfNullOrEmptyString((String)mapperModel.getConfig().get(RESERVED_USERNAMES));
        logger.debugf("Reserved usernames are: %s", reservedUsernames);
        boolean autoResolveConflicts = Boolean.valueOf((String)mapperModel.getConfig().get(AUTO_RESOLVE_CONFLICT));
        logger.debugf("Auto resolve conflict setting is: %b", (Object)autoResolveConflicts);
        String email = context.getEmail();
        logger.debugf("Email address is: %s", (Object)email);
        Object username = email.substring(0, email.indexOf(64)).toLowerCase();
        logger.debugf("Extracted raw username is: %s", username);
        for (Character c : ((String)username).chars().mapToObj(e -> Character.valueOf((char)e)).collect(Collectors.toSet())) {
            if (UsernameFromMailMapper.isChar(c.charValue()) || UsernameFromMailMapper.isDigit(c.charValue()) || c == DASH || c == PERIOD) continue;
            logger.debugf("Replacing unneeded char (%c) with %c", (Object)c, (Object)PERIOD);
            username = ((String)username).replace(c.charValue(), PERIOD.charValue());
        }
        boolean usernameAlreadyExists = this.usernameAlreadyExists(session, realm, (String)username);
        if (usernameAlreadyExists && autoResolveConflicts || reservedUsernames.contains(username)) {
            if (usernameAlreadyExists) {
                logger.debugf("Username already exists: %s", username);
            } else {
                logger.info((Object)"Username is one of the reserved usernames");
            }
            int i = 1;
            while (true) {
                String tempUsername = (String)username + PERIOD + i;
                logger.tracef("Trying with username: %s", (Object)tempUsername);
                if (!this.usernameAlreadyExists(session, realm, tempUsername)) {
                    logger.tracef("Username is OK: %s", (Object)tempUsername);
                    username = tempUsername;
                    break;
                }
                logger.tracef("Username already exists: %s", (Object)tempUsername);
                ++i;
            }
        }
        logger.debugf("Final computed username is: %s", username);
        context.setModelUsername((String)username);
    }

    private static boolean isChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean usernameAlreadyExists(KeycloakSession session, RealmModel realm, String username) {
        return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)session, (RealmModel)realm, (String)username) != null;
    }

    public String getHelpText() {
        return "Extract the IdP username from the e-mail address (before the '@' char).";
    }

    protected Set<String> getConfigValuesOrEmptySetIfNullOrEmptyString(String str) {
        if (str == null || "".equals(str)) {
            return Collections.emptySet();
        }
        String[] objClasses = str.split(COMMA);
        HashSet<String> trimmed = new HashSet<String>();
        for (String objectClass : objClasses) {
            if ((objectClass = objectClass.trim()).length() <= 0) continue;
            trimmed.add(objectClass);
        }
        return trimmed;
    }

    static {
        IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
        configProperties = ProviderConfigurationBuilder.create().property().name(RESERVED_USERNAMES).label("Reserved Usernames").helpText("List of reserved usernames (comma separated) that cannot be accepted. If found a progressive suffix number will we added.").type("String").defaultValue((Object)"cyrus,postfix").add().property().name(AUTO_RESOLVE_CONFLICT).label("Auto resolve conflicts").helpText("Automatically add a numeric suffix to avoid already existing username conflict.").type("boolean").add().build();
    }
}

