function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from "../../../../common/keycloak/web_modules/react.js";
import { Button, Grid, GridItem, Expandable, Modal } from "../../../../common/keycloak/web_modules/@patternfly/react-core.js";
import { AccountServiceContext } from "../../account-service/AccountServiceContext.js";
import { Msg } from "../../widgets/Msg.js";
import { ContentPage } from "../ContentPage.js";
import { ContentAlert } from "../ContentAlert.js";
import { AvatarForm } from "./AvatarForm.js";
export class AccountExtraPage extends React.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "context", void 0);

    _defineProperty(this, "handleModalToggle", open => {
      this.setState({
        isModalOpen: open
      });
    });

    _defineProperty(this, "modalConfirmDelete", event => {
      const accountUrl = this.context["accountUrl"];
      const deleteUrl = accountUrl + "-delete/request-delete";
      this.context.doPost(deleteUrl, {}).then(() => {
        ContentAlert.success('accountDeletedMessage');
        window.location.reload();
      });
      this.setState({
        isModalOpen: false
      });
    });

    this.state = {
      isModalOpen: false
    };
  }

  render() {
    const accountUrl = this.context["accountUrl"];
    return React.createElement(ContentPage, {
      title: "accountExtraInfoHtmlTitle",
      introMessage: "accountExtraSubMessage"
    }, React.createElement(AvatarForm, {
      accountUrl: accountUrl
    }), React.createElement("div", {
      id: "delete-account",
      style: {
        marginTop: "30px"
      }
    }, React.createElement(Expandable, {
      toggleText: Msg.localize('deleteAccount')
    }, React.createElement(Grid, {
      gutter: "sm"
    }, React.createElement(GridItem, {
      span: 8
    }, React.createElement("p", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountInfoMessage')
      }
    })), React.createElement(GridItem, {
      span: 4
    }, React.createElement(Button, {
      id: "delete-account-btn",
      variant: "danger",
      onClick: e => this.handleModalToggle(true),
      className: "delete-button"
    }, React.createElement(Msg, {
      msgKey: "doDelete"
    }))))), React.createElement(Modal, {
      width: '50%',
      title: Msg.localize('deleteAccountDialogHeader'),
      isOpen: this.state.isModalOpen,
      onClose: () => this.handleModalToggle(false),
      actions: [React.createElement(Button, {
        key: "confirm",
        variant: "danger",
        onClick: this.modalConfirmDelete
      }, React.createElement(Msg, {
        msgKey: "doDeleteConfirm"
      })), React.createElement(Button, {
        key: "cancel",
        variant: "secondary",
        onClick: e => this.handleModalToggle(false)
      }, React.createElement(Msg, {
        msgKey: "doCancel"
      }))]
    }, React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountWarningMessage')
      }
    }), React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountConfirmMessage')
      }
    }))));
  }

}

_defineProperty(AccountExtraPage, "contextType", AccountServiceContext);
//# sourceMappingURL=AccountExtraPage.js.map