function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import * as React from "../../../../common/keycloak/web_modules/react.js";
import { PageSection, PageSectionVariants, Button, Grid, GridItem, ExpandableSection, Modal } from "../../../../common/keycloak/web_modules/@patternfly/react-core.js";
import { AccountServiceContext } from "../../account-service/AccountServiceContext.js";
import { Msg } from "../../widgets/Msg.js";
import { ContentPage } from "../ContentPage.js";
import { ContentAlert } from "../ContentAlert.js";
import { AvatarForm } from "./AvatarForm.js";
export class AccountExtraPage extends React.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "context", void 0);

    _defineProperty(this, "handleModalToggle", open => {
      this.setState({
        isModalOpen: open
      });
    });

    _defineProperty(this, "modalConfirmDelete", event => {
      const accountUrl = this.context["accountUrl"];
      const deleteUrl = accountUrl + "-delete/request-delete";
      this.context.doPost(deleteUrl, {}).then(() => {
        ContentAlert.success('accountDeletedMessage');
        window.location.reload();
      });
      this.setState({
        isModalOpen: false
      });
    });

    this.state = {
      isModalOpen: false
    };
  }

  render() {
    const accountUrl = this.context["accountUrl"];
    return /*#__PURE__*/React.createElement(ContentPage, {
      title: "accountExtraInfoHtmlTitle",
      introMessage: "accountExtraSubMessage"
    }, /*#__PURE__*/React.createElement(PageSection, {
      isFilled: true,
      variant: PageSectionVariants.light
    }, /*#__PURE__*/React.createElement(AvatarForm, {
      accountUrl: accountUrl
    }), /*#__PURE__*/React.createElement("div", {
      id: "delete-account",
      style: {
        marginTop: "30px"
      }
    }, /*#__PURE__*/React.createElement(ExpandableSection, {
      toggleText: Msg.localize('deleteAccount'),
      displaySize: "large"
    }, /*#__PURE__*/React.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React.createElement(GridItem, {
      span: 8
    }, /*#__PURE__*/React.createElement("p", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountInfoMessage')
      }
    })), /*#__PURE__*/React.createElement(GridItem, {
      span: 4
    }, /*#__PURE__*/React.createElement(Button, {
      id: "delete-account-btn",
      variant: "danger",
      onClick: e => this.handleModalToggle(true),
      className: "delete-button"
    }, /*#__PURE__*/React.createElement(Msg, {
      msgKey: "doDelete"
    }))))), /*#__PURE__*/React.createElement(Modal, {
      width: '50%',
      title: Msg.localize('deleteAccountDialogHeader'),
      isOpen: this.state.isModalOpen,
      onClose: () => this.handleModalToggle(false),
      actions: [/*#__PURE__*/React.createElement(Button, {
        key: "confirm",
        variant: "danger",
        onClick: this.modalConfirmDelete
      }, /*#__PURE__*/React.createElement(Msg, {
        msgKey: "doDeleteConfirm"
      })), /*#__PURE__*/React.createElement(Button, {
        key: "cancel",
        variant: "secondary",
        onClick: e => this.handleModalToggle(false)
      }, /*#__PURE__*/React.createElement(Msg, {
        msgKey: "doCancel"
      }))]
    }, /*#__PURE__*/React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountWarningMessage')
      }
    }), /*#__PURE__*/React.createElement("div", {
      dangerouslySetInnerHTML: {
        __html: Msg.localize('deleteAccountConfirmMessage')
      }
    })))));
  }

}

_defineProperty(AccountExtraPage, "contextType", AccountServiceContext);
//# sourceMappingURL=AccountExtraPage.js.map