/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc.mapper;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class D4ScienceContextMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper {
    private static final Logger logger = Logger.getLogger(D4ScienceContextMapper.class);
    public static final String HTTP_REQUEST_HEADER_NAME = "d4scm.header-name";
    public static final String NARROW_RESOURCE_ACCESS = "d4scm.narrow-ra";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    private static final int PRIORITY = Integer.MAX_VALUE;
    private static final String DISPLAY_TYPE = "OIDC D4Science Context Mapper";
    private static final String PROVIDER_ID = "oidc-d4scince-context-mapper";
    public static final String DEFAULT_HEADER_NAME = "X-D4Science-Context";
    public static final String DEFAULT_TOKEN_CLAIM = "aud";

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getDisplayType() {
        return DISPLAY_TYPE;
    }

    public String getHelpText() {
        return "Maps the D4Science context audience by reading the configured header's value and sets it as the configured token claim, if it is in scope";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        if (token instanceof AccessToken) {
            AccessToken accessToken = (AccessToken)token;
            String headerName = (String)mappingModel.getConfig().get(HTTP_REQUEST_HEADER_NAME);
            if (headerName == null || "".equals(headerName)) {
                headerName = DEFAULT_HEADER_NAME;
            }
            logger.debugf("Looking for the '%s' header", (Object)headerName);
            String requestedD4SContext = keycloakSession.getContext().getRequestHeaders().getHeaderString(headerName);
            if (requestedD4SContext != null && !"".equals(requestedD4SContext)) {
                logger.debugf("Checking resource access for the requested context: %s", (Object)requestedD4SContext);
                AccessToken.Access contextAccessInResourceAccess = accessToken.getResourceAccess(requestedD4SContext);
                if (contextAccessInResourceAccess != null) {
                    logger.debugf("Mapping it as the configured claim: %s", mappingModel.getConfig().get("claim.name"));
                    OIDCAttributeMapperHelper.mapClaim((IDToken)token, (ProtocolMapperModel)mappingModel, (Object)requestedD4SContext);
                    if (Boolean.parseBoolean((String)mappingModel.getConfig().get(NARROW_RESOURCE_ACCESS))) {
                        accessToken.getResourceAccess().clear();
                        accessToken.getResourceAccess().put(requestedD4SContext, contextAccessInResourceAccess);
                    }
                } else {
                    logger.warnf("Requested context '%s' is not accessible to the client: %s", (Object)requestedD4SContext, (Object)clientSessionCtx.getClientSession().getClient().getName());
                }
            }
        }
    }

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(CONFIG_PROPERTIES);
        CONFIG_PROPERTIES.forEach(conf -> {
            if ("claim.name".equals(conf.getName())) {
                conf.setDefaultValue((Object)DEFAULT_TOKEN_CLAIM);
            }
            conf.setReadOnly(true);
        });
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(CONFIG_PROPERTIES, D4ScienceContextMapper.class);
        ProviderConfigProperty headerProperty = new ProviderConfigProperty();
        headerProperty.setName(HTTP_REQUEST_HEADER_NAME);
        headerProperty.setLabel("HTTP request header name with the requested context");
        headerProperty.setType("String");
        headerProperty.setHelpText("The HTTP header that contains the requested context to be mapped as the requested in the configured claim");
        headerProperty.setDefaultValue((Object)DEFAULT_HEADER_NAME);
        headerProperty.setReadOnly(true);
        CONFIG_PROPERTIES.add(headerProperty);
        ProviderConfigProperty narrowProperty = new ProviderConfigProperty();
        narrowProperty.setName(NARROW_RESOURCE_ACCESS);
        narrowProperty.setLabel("Narrow down resource access array?");
        narrowProperty.setType("boolean");
        narrowProperty.setHelpText("Narrow down resource access claim to contain only the requested context entry");
        CONFIG_PROPERTIES.add(narrowProperty);
    }
}

