/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest.examples;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.utils.InnerMethodName;

@Path(value="auth")
public class AuthenticatedService {
    private static final String ALLOWED_ROLE = "myRole";
    private static final String ALLOWED_ROLE_ORG = "OrganizationMember";
    private static final String ALLOWED_ROLE_MEMBER = "Member";

    @AuthorizationControl(allowedRoles={"OrganizationMember"})
    @GET
    @Path(value="org_member")
    @Produces(value={"text/plain"})
    public String authorizedOrg() {
        InnerMethodName.set((String)"auth");
        Secret secret = SecretManagerProvider.get();
        String userId = secret.getOwner().getId();
        String context = secret.getContext();
        return String.format("User %s in context %s is authorized to execute this method because he has the role %s", userId, context, ALLOWED_ROLE_ORG);
    }

    @AuthorizationControl(allowedRoles={"Member"})
    @GET
    @Path(value="member")
    @Produces(value={"text/plain"})
    public String authorizedMember() {
        InnerMethodName.set((String)"auth");
        Secret secret = SecretManagerProvider.get();
        String userId = secret.getOwner().getId();
        String context = secret.getContext();
        return String.format("User %s in context %s is authorized to execute this method because he has the role %s", userId, context, ALLOWED_ROLE_MEMBER);
    }

    @AuthorizationControl(allowedRoles={"myRole"})
    @GET
    @Path(value="")
    @Produces(value={"text/plain"})
    public String authorized() {
        InnerMethodName.set((String)"auth");
        Secret secret = SecretManagerProvider.get();
        String userId = secret.getOwner().getId();
        String context = secret.getContext();
        return String.format("User %s in context %s is authorized to execute this method because he has the role %s", userId, context, ALLOWED_ROLE);
    }
}

