/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.CouchbaseConnectionFactoryBuilder;
import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.couchbase.entities.MetaIndex;
import org.gcube.couchbase.helpers.CouchBaseDataTypesHelper;
import org.gcube.couchbase.helpers.CouchBaseHelper;
import org.gcube.couchbase.helpers.CouchBaseRestHelper;
import org.gcube.indexmanagement.common.ForwardIndexField;
import org.gcube.indexmanagement.common.ForwardIndexType;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchBaseNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CouchBaseNode.class);
    private static final String designDocName = "forward_index_des_doc";
    private static final Integer proxyPort = 11215;
    private String nodeIP = null;
    private String nodePort = null;
    private String nodeAddress = null;
    private String bucketName = "default_new";
    private String username = "Administrator";
    private String password = "mycouchbase";
    private Integer ramQuota = 512;
    private Integer replicaNumber = 1;
    private MetaIndex metaIndex = null;
    private Map<String, CouchBaseDataTypesHelper.DataType> keys = null;
    private String scope;
    private transient RRadaptor rradaptor;
    private transient CouchbaseClient client = null;

    public MetaIndex getMetaIndex() {
        return this.metaIndex;
    }

    public void setMetaIndex(MetaIndex metaIndex) {
        this.metaIndex = metaIndex;
    }

    public Map<String, CouchBaseDataTypesHelper.DataType> getKeys() {
        return this.keys;
    }

    public RRadaptor getRradaptor() {
        return this.rradaptor;
    }

    public String getDesignDocName() {
        return designDocName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getScope() {
        return this.scope;
    }

    private CouchBaseNode() {
        logger.info("initializing grs2 and resource registry");
        this.initialize();
    }

    public CouchBaseNode(String clusterName, Integer replicas, Integer ramQuota, String scope) {
        this();
        this.bucketName = clusterName;
        this.replicaNumber = replicas;
        this.ramQuota = ramQuota;
        this.scope = scope;
        this.metaIndex = new MetaIndex();
        this.keys = new HashMap<String, CouchBaseDataTypesHelper.DataType>();
        logger.info("bucketName    : " + this.bucketName);
        logger.info("replicaNumber : " + this.replicaNumber);
        logger.info("scope         : " + scope);
        logger.info("metaIndex     : new ");
        logger.info("keys          : " + this.keys);
    }

    public CouchBaseNode(String nodeIP, String nodePort, String username, String password, String clusterName, Integer replicas, Integer ramQuota, String scope) {
        this(nodeIP, nodePort, clusterName, replicas, ramQuota, scope);
        this.username = username;
        this.password = password;
        logger.info("username : " + username);
        logger.info("password : " + password);
    }

    public CouchBaseNode(String nodeIP, String nodePort, String clusterName, Integer replicas, Integer ramQuota, String scope) {
        this(clusterName, replicas, ramQuota, scope);
        this.nodeIP = nodeIP;
        this.nodePort = nodePort;
        logger.info("nodeIP   : " + nodeIP);
        logger.info("nodePort : " + nodePort);
    }

    private void initializeClient(List<URI> nodes) throws IOException {
        if (this.client == null) {
            logger.info("initializing client with nodes : " + nodes);
            CouchbaseConnectionFactoryBuilder cfb = new CouchbaseConnectionFactoryBuilder();
            cfb.setOpTimeout(45000L);
            cfb.setOpQueueMaxBlockTime(20000L);
            this.client = new CouchbaseClient(cfb.buildCouchbaseConnection(nodes, this.bucketName, ""));
        } else {
            logger.warn("Client already initialized");
        }
    }

    private void createBucket() throws Exception {
        CouchBaseRestHelper.createBucket(this.nodeIP, this.nodePort, this.username, this.password, this.bucketName, this.ramQuota, this.replicaNumber, proxyPort);
    }

    public boolean checkIfBucketExists() {
        boolean res = CouchBaseRestHelper.checkIfBucketExists(this.nodeIP, this.nodePort, this.username, this.password, this.bucketName);
        logger.info("bucket exists returned : " + res);
        return res;
    }

    private void deleteBucket() throws Exception {
        CouchBaseRestHelper.deleteBucketSDK(this.nodeIP, this.nodePort, this.username, this.password, this.bucketName);
        if (CouchBaseRestHelper.checkIfBucketExists(this.nodeIP, this.nodePort, this.username, this.password, this.bucketName)) {
            throw new Exception("Deletion failed. Check the previous exeption");
        }
        logger.info("Deletion succeded. Please ignore the previous exception");
    }

    public void createCluster(boolean forceCreate) throws Exception {
        int tries;
        block10: {
            if (forceCreate || !this.checkIfBucketExists()) {
                logger.info("bucket does not exist. will be created");
                try {
                    this.createBucket();
                }
                catch (Exception ex1) {
                    int tries2;
                    logger.info("Error creating new bucket... Probably exists. Trying to delete it and recreate it", (Throwable)ex1);
                    this.deleteBucket();
                    logger.info("Recreating the bucket..");
                    logger.info("Should wait a bit after creating the bucket again");
                    Exception ex = null;
                    for (tries2 = 10; tries2 > 0; --tries2) {
                        logger.info("Waiting a bit (3 sec)");
                        logger.info("tries left : " + tries2);
                        Thread.sleep(3000L);
                        try {
                            this.createBucket();
                            break;
                        }
                        catch (Exception e) {
                            ex = e;
                            continue;
                        }
                    }
                    if (tries2 != 0) break block10;
                    throw new Exception("Couldn't create bucket", ex);
                }
            }
        }
        for (tries = 5; tries > 0; --tries) {
            logger.info("Waiting a bit (1 sec)");
            logger.info("tries left : " + tries);
            Thread.sleep(1000L);
            try {
                this.connectTo(this.nodeIP, this.nodePort);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (tries == 0) {
            throw new Exception("Couldn't connect to (self) cluster");
        }
    }

    public void connectTo(String host, String port) throws IOException {
        ArrayList<URI> nodes = new ArrayList<URI>();
        nodes.add(URI.create("http://" + host + ":" + port + "/pools"));
        this.initializeClient(nodes);
    }

    public void joinCluster(String knownHostIP, String knownHostPort) throws Exception {
        Map<String, String> clusterNodes = CouchBaseRestHelper.getClusterNodesAddressesAndPorts(knownHostIP, knownHostPort, this.username, this.password);
        String port = clusterNodes.get(this.nodeIP);
        if (port != null && port.equalsIgnoreCase(this.nodePort)) {
            logger.info("Node already in cluster");
        } else {
            logger.info("Node not in cluster");
            logger.info("Adding node...");
            this.nodeAddress = CouchBaseRestHelper.addNode(knownHostIP, knownHostPort, this.username, this.password, this.nodeIP, this.username, this.password);
            logger.info("Rebalancing cluster...");
            CouchBaseRestHelper.rebalanceCluster(knownHostIP, knownHostPort, this.username, this.password);
        }
        this.connectTo(this.nodeIP, this.nodePort);
    }

    public void joinCluster(Map<String, String> knownHosts) throws Exception {
        for (Map.Entry<String, String> knownHost : knownHosts.entrySet()) {
            try {
                logger.info("Trying to connect to : " + knownHost.getKey() + " port : " + knownHost.getValue());
                this.joinCluster(knownHost.getKey(), knownHost.getValue());
                break;
            }
            catch (Exception e) {
                logger.error("Connecting to : " + knownHost.getKey(), (Object)(knownHost.getValue() + " failed!"), (Object)e);
            }
        }
    }

    private void leaveCluster() throws Exception {
        List<String> clusterNodes;
        if (this.nodeAddress == null) {
            logger.info("nodeAddress has not been set yet");
            this.nodeAddress = "ns_1@" + this.nodeIP;
        }
        if ((clusterNodes = CouchBaseRestHelper.getClusterNodes(this.nodeIP, this.nodePort, this.username, this.password)).size() == 1) {
            logger.info("This is the last node of the cluster. Cannot be removed");
            return;
        }
        CouchBaseRestHelper.removeNode(this.nodeIP, this.nodePort, this.username, this.password, this.nodeAddress);
    }

    public void shutdown() throws Exception {
        this.client.shutdown();
        this.leaveCluster();
    }

    public void destroy() throws Exception {
        this.deleteBucket();
        this.shutdown();
    }

    public void delete() throws Exception {
        this.deleteBucket();
    }

    public void clear() throws Exception {
        int tries;
        logger.info("Deleting the bucket..");
        this.deleteBucket();
        logger.info("Recreating the bucket..");
        logger.info("Should wait a bit after creating the bucket again");
        Exception ex = null;
        for (tries = 10; tries > 0; --tries) {
            logger.info("Waiting a bit (3 sec)");
            logger.info("tries left : " + tries);
            Thread.sleep(3000L);
            try {
                this.createBucket();
                break;
            }
            catch (Exception e) {
                ex = e;
                continue;
            }
        }
        if (tries == 0) {
            throw new Exception("Couldn't create bucket", ex);
        }
        this.metaIndex = new MetaIndex();
        this.commitMetaIndexToDatabase();
    }

    public void loadKeysFromMetaIndex() {
        GCUBEScope scope = GCUBEScope.getScope((String)this.scope);
        for (Map.Entry<String, String> kv : this.metaIndex.getIndexKeys().entrySet()) {
            String fieldName = kv.getKey();
            String indexTypeID = kv.getValue();
            ForwardIndexType indexType = new ForwardIndexType(indexTypeID, scope);
            ForwardIndexField keyField = indexType.getKeyField();
            if (keyField == null) {
                logger.error("No keyField found for indexTypeID : " + indexTypeID + " in scope : " + scope.getName());
                logger.error("fieldName : " + fieldName);
                logger.error("Probably wrong indexTypeID given");
                continue;
            }
            logger.info("keyfield : " + keyField.getName() + " , datatype : " + keyField.getDataType());
            CouchBaseDataTypesHelper.DataType datatype = CouchBaseDataTypesHelper.getDataType(keyField.getDataType());
            this.keys.put(fieldName, datatype);
        }
        logger.info("Loaded Keys : " + this.getKeys());
    }

    public void setIndexType(Map<String, String> keysValues) {
        this.keys.clear();
        this.addIndexTypes(keysValues);
    }

    public void addIndexTypes(Map<String, String> keysValues) {
        if (keysValues == null || keysValues.size() == 0) {
            logger.warn("No keysValues are given to build index");
            logger.warn("Skipping the index creation");
            return;
        }
        GCUBEScope scope = GCUBEScope.getScope((String)this.scope);
        for (Map.Entry<String, String> kv : keysValues.entrySet()) {
            String fieldName = kv.getKey();
            String indexTypeID = kv.getValue();
            ForwardIndexType indexType = new ForwardIndexType(indexTypeID, scope);
            ForwardIndexField keyField = indexType.getKeyField();
            if (keyField == null) {
                logger.error("No keyField found for indexTypeID : " + indexTypeID + " in scope : " + scope.getName());
                logger.error("fieldName : " + fieldName);
                logger.error("Probably wrong indexTypeID given");
                continue;
            }
            logger.info("keyfield : " + keyField.getName() + " , datatype : " + keyField.getDataType());
            CouchBaseDataTypesHelper.DataType datatype = CouchBaseDataTypesHelper.getDataType(keyField.getDataType());
            this.keys.put(fieldName, datatype);
        }
        this.metaIndex.getIndexKeys().putAll(keysValues);
        logger.info("Keys : " + this.getKeys());
        CouchBaseHelper.createIndexes(this.client, this.getBucketName(), this.getDesignDocName(), this.getKeys());
    }

    public String query(String queryString) {
        return CouchBaseHelper.query(this.client, this.metaIndex, this.bucketName, designDocName, this.keys, this.rradaptor, queryString);
    }

    public boolean feedLocator(String locator) throws GRS2ReaderException, URISyntaxException {
        boolean feedResult = CouchBaseHelper.feedLocator(this.client, locator, this.getMetaIndex());
        logger.info("feedResult : " + feedResult);
        if (feedResult) {
            this.commit();
        }
        return feedResult;
    }

    public void deleteDocuments(List<String> docIDs) {
        CouchBaseHelper.deleteDocsCouchBase(this.client, docIDs);
    }

    private void commit() {
        CouchBaseHelper.commit(this.client, this.getBucketName(), this.getDesignDocName(), this.getKeys());
    }

    public void loadMetaFromDatabase() {
        this.metaIndex.loadFromDatabase(this.client);
    }

    public void commitMetaIndexToDatabase() {
        this.metaIndex.saveToDatabase(this.client);
    }

    private void initialize() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(GHNContext.getContext().getHostname(), new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        logger.info("Initializing ResourceRegistry");
        try {
            ResourceRegistry.startBridging();
            TimeUnit.SECONDS.sleep(1L);
            while (!ResourceRegistry.isInitialBridgingComplete()) {
                logger.info("registry not ready...sleeping");
                TimeUnit.SECONDS.sleep(10L);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Resource Registry could not be initialized", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            logger.error("Resource Registry could not be initialized", (Throwable)e);
            return;
        }
        this.rradaptor = new RRadaptor(this.scope);
        logger.info("Initializing ResourceRegistry is DONE");
    }
}

