package org.gcube.couchbase.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * 
 * @author Alex Antoniadis
 *
 */
public class DateHelper {
	
	private static DateFormat df = new SimpleDateFormat("yyyy/M/d");

	public static String toDateString(long datetime) {
		return new Date(datetime).toString();
	}

	public static Long toDateTime(Date date) {
		return date.getTime();
	}

	public static String toCalendarDateString(long datetime) {
		Calendar cal = GregorianCalendar.getInstance();
		cal.setTimeInMillis(datetime);

		return calendarToDateString(cal);
	}

	public static synchronized String calendarToDateString(Calendar cal) {
		return df.format(cal.getTime());
	}

	public static Long toCalendarDateTime(GregorianCalendar gc) {
		return gc.getTimeInMillis();
	}
}