package org.gcube.couchbase.entities;

/**
 * 
 * @author Alex Antoniadis
 * 
 */
public enum Operator {
	NA, EQUAL, NOT_EQUAL, GREATER_THAN, GREATER_EQUAL, LESS_THAN, LESS_EQUAL, GREATER_THAN_AND_LESS_THAN, GREATER_EQUAL_AND_LESS_EQUAL;

	public static Operator flipOperator(Operator op) {
		Operator flippedOper = null;
		switch (op) {
		case NA:
			flippedOper = NA;
			break;
		case EQUAL:
			flippedOper = EQUAL;
			break;
		case NOT_EQUAL:
			flippedOper = NOT_EQUAL;
			break;
		case GREATER_THAN:
			flippedOper = LESS_THAN;
			break;
		case GREATER_EQUAL:
			flippedOper = LESS_EQUAL;
			break;
		case LESS_THAN:
			flippedOper = GREATER_THAN;
			break;
		case LESS_EQUAL:
			flippedOper = GREATER_EQUAL;
			break;
		default:
			break;
		}

		return flippedOper;
	}

	public static String flipOperator(String operatorStr) {
		Operator op = getOperatorFromString(operatorStr);
		return getStringFromOperator(flipOperator(op));
	}

	public static String getStringFromOperator(Operator op) {
		String operatorString = null;

		switch (op) {
		case NA:
			operatorString = "#";
			break;
		case EQUAL:
			operatorString = "=";
			break;
		case NOT_EQUAL:
			operatorString = "!=";
			break;
		case LESS_THAN:
			operatorString = "<=";
			break;
		case LESS_EQUAL:
			operatorString = "<";
			break;
		case GREATER_THAN:
			operatorString = ">";
			break;
		case GREATER_EQUAL:
			operatorString = ">=";
			break;
		default:
			break;
		}

		return operatorString;
	}

	public static Operator getOperatorFromString(String operatorStr) {
		Operator op = null;

		if (operatorStr.equals("="))
			op = EQUAL;
		else if (operatorStr.equals("#"))
			op = NA;
		else if (operatorStr.equals("<"))
			op = LESS_THAN;
		else if (operatorStr.equals("<="))
			op = LESS_EQUAL;
		else if (operatorStr.equals(">"))
			op = GREATER_THAN;
		else if (operatorStr.equals(">="))
			op = GREATER_EQUAL;
		/*
		 * switch (operatorStr) { case "=": op = EQUAL; break; case "<": op =
		 * LESS_THAN; break; case "<=": op = LESS_EQUAL; break; case ">": op =
		 * GREATER_THAN; break; case ">=": op = GREATER_EQUAL; break;
		 * 
		 * default: break; }
		 */

		return op;
	}
}
