// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/gcube/elasticsearch/parser/ElasticSearchParser.g 2014-08-27 09:53:21

    package org.gcube.elasticsearch.parser;
    import java.lang.Double;
    import java.util.HashSet;
    import java.util.AbstractMap.SimpleEntry;
    import java.util.Set;
    import org.gcube.elasticsearch.parser.helpers.ParserHelpers;
    import org.elasticsearch.common.geo.GeoDistance;
    import org.elasticsearch.common.unit.DistanceUnit;
    import org.elasticsearch.common.xcontent.ToXContent;
    import org.elasticsearch.index.query.QueryBuilder;
    import org.elasticsearch.index.query.QueryBuilders;
    import org.elasticsearch.index.query.FilterBuilder;
    import org.elasticsearch.index.query.FilterBuilders;
    import org.elasticsearch.index.query.GeoDistanceFilterBuilder;
    import org.elasticsearch.index.query.GeoPolygonFilterBuilder;
    import com.spatial4j.core.context.SpatialContext;
    import com.spatial4j.core.shape.Point;
    import com.spatial4j.core.shape.impl.PointImpl;
    import org.slf4j.Logger;
    import org.slf4j.LoggerFactory;
    import org.gcube.indexmanagement.resourceregistry.RRadaptor;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class ElasticSearchParserParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "TWODOUBLEQUOTES", "SORTBY", "PROJECT", "LPAREN", "RPAREN", "DISTANCE", "COMMA", "OVERLAPS", "EQUALS", "GREATER", "LESS", "GEQUAL", "LEQUAL", "NOTEQUAL", "EXACT", "SLASH", "CHARSTRING1", "CHARSTRING2", "AND", "OR", "NOT", "PROX", "LBRACK", "RBRACK", "DOUBLE", "INT", "ASC", "DESC", "FUSE", "WHITESPACE"
    };
    public static final int EOF=-1;
    public static final int TWODOUBLEQUOTES=4;
    public static final int SORTBY=5;
    public static final int PROJECT=6;
    public static final int LPAREN=7;
    public static final int RPAREN=8;
    public static final int DISTANCE=9;
    public static final int COMMA=10;
    public static final int OVERLAPS=11;
    public static final int EQUALS=12;
    public static final int GREATER=13;
    public static final int LESS=14;
    public static final int GEQUAL=15;
    public static final int LEQUAL=16;
    public static final int NOTEQUAL=17;
    public static final int EXACT=18;
    public static final int SLASH=19;
    public static final int CHARSTRING1=20;
    public static final int CHARSTRING2=21;
    public static final int AND=22;
    public static final int OR=23;
    public static final int NOT=24;
    public static final int PROX=25;
    public static final int LBRACK=26;
    public static final int RBRACK=27;
    public static final int DOUBLE=28;
    public static final int INT=29;
    public static final int ASC=30;
    public static final int DESC=31;
    public static final int FUSE=32;
    public static final int WHITESPACE=33;

    // delegates
    // delegators


        public ElasticSearchParserParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public ElasticSearchParserParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return ElasticSearchParserParser.tokenNames; }
    public String getGrammarFileName() { return "org/gcube/elasticsearch/parser/ElasticSearchParser.g"; }


    			public ArrayList<String> projects = new ArrayList<String>();
    			public ArrayList<SimpleEntry<String,String>> sortbys = new ArrayList<SimpleEntry<String,String>>();
    			public ArrayList<String> distincts = new ArrayList<String>();
    			public Set<String> collections = new HashSet<String>();
    			
    			private final String ASCENDING = "ASC";
    			private final String DISTINCT = "distinct";
    			private final String ALLINDEXES = "allindexes";
    			
    			private RRadaptor adaptor;
    			private static final Logger logger = LoggerFactory.getLogger(ElasticSearchParserParser.class);
    			
    			private int count;
             


    // $ANTLR start "esQuery"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:76:1: esQuery[RRadaptor adaptor] returns [QueryBuilder qb] : ( TWODOUBLEQUOTES EOF | sc= scopedClause ( ({...}? => sortSpec ) | ({...}? => projectSpec ) )* EOF | EOF );
    public final QueryBuilder esQuery(RRadaptor adaptor) throws RecognitionException {
        QueryBuilder qb = null;

        QueryBuilder sc = null;


         boolean s = false, p = false; this.adaptor = adaptor; 
        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:78:2: ( TWODOUBLEQUOTES EOF | sc= scopedClause ( ({...}? => sortSpec ) | ({...}? => projectSpec ) )* EOF | EOF )
            int alt2=3;
            switch ( input.LA(1) ) {
            case TWODOUBLEQUOTES:
                {
                alt2=1;
                }
                break;
            case LPAREN:
            case DISTANCE:
            case OVERLAPS:
            case CHARSTRING1:
            case CHARSTRING2:
            case DOUBLE:
            case INT:
                {
                alt2=2;
                }
                break;
            case EOF:
                {
                alt2=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:78:4: TWODOUBLEQUOTES EOF
                    {
                    match(input,TWODOUBLEQUOTES,FOLLOW_TWODOUBLEQUOTES_in_esQuery67); 
                    match(input,EOF,FOLLOW_EOF_in_esQuery69); 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:4: sc= scopedClause ( ({...}? => sortSpec ) | ({...}? => projectSpec ) )* EOF
                    {
                    pushFollow(FOLLOW_scopedClause_in_esQuery81);
                    sc=scopedClause();

                    state._fsp--;

                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:22: ( ({...}? => sortSpec ) | ({...}? => projectSpec ) )*
                    loop1:
                    do {
                        int alt1=3;
                        int LA1_0 = input.LA(1);

                        if ( (LA1_0==SORTBY) && (( s == false ))) {
                            alt1=1;
                        }
                        else if ( (LA1_0==PROJECT) && (( p == false ))) {
                            alt1=2;
                        }


                        switch (alt1) {
                    	case 1 :
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:23: ({...}? => sortSpec )
                    	    {
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:23: ({...}? => sortSpec )
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:25: {...}? => sortSpec
                    	    {
                    	    if ( !(( s == false )) ) {
                    	        throw new FailedPredicateException(input, "esQuery", " s == false ");
                    	    }
                    	    pushFollow(FOLLOW_sortSpec_in_esQuery89);
                    	    sortSpec();

                    	    state._fsp--;

                    	     s = true; 

                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:70: ({...}? => projectSpec )
                    	    {
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:70: ({...}? => projectSpec )
                    	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:80:72: {...}? => projectSpec
                    	    {
                    	    if ( !(( p == false )) ) {
                    	        throw new FailedPredicateException(input, "esQuery", " p == false ");
                    	    }
                    	    pushFollow(FOLLOW_projectSpec_in_esQuery102);
                    	    projectSpec();

                    	    state._fsp--;

                    	     p = true; 

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop1;
                        }
                    } while (true);

                    match(input,EOF,FOLLOW_EOF_in_esQuery111); 
                    qb = sc;

                    }
                    break;
                case 3 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:82:4: EOF
                    {
                    match(input,EOF,FOLLOW_EOF_in_esQuery122); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return qb;
    }
    // $ANTLR end "esQuery"


    // $ANTLR start "sortSpec"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:85:1: sortSpec returns [String value] : SORTBY (s= singleSpec (o= order )? )+ ;
    public final String sortSpec() throws RecognitionException {
        String value = null;

        String s = null;

        String o = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:2: ( SORTBY (s= singleSpec (o= order )? )+ )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:4: SORTBY (s= singleSpec (o= order )? )+
            {
            match(input,SORTBY,FOLLOW_SORTBY_in_sortSpec136); 
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:11: (s= singleSpec (o= order )? )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case CHARSTRING1:
                case CHARSTRING2:
                case DOUBLE:
                case INT:
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:13: s= singleSpec (o= order )?
            	    {
            	     o = this.ASCENDING; 
            	    pushFollow(FOLLOW_singleSpec_in_sortSpec146);
            	    s=singleSpec();

            	    state._fsp--;

            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:52: (o= order )?
            	    int alt3=2;
            	    switch ( input.LA(1) ) {
            	        case ASC:
            	        case DESC:
            	            {
            	            alt3=1;
            	            }
            	            break;
            	    }

            	    switch (alt3) {
            	        case 1 :
            	            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:86:54: o= order
            	            {
            	            pushFollow(FOLLOW_order_in_sortSpec154);
            	            o=order();

            	            state._fsp--;


            	            }
            	            break;

            	    }

            	     sortbys.add(new SimpleEntry<>(ParserHelpers.translateField(s,adaptor), o)); 

            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "sortSpec"


    // $ANTLR start "projectSpec"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:89:1: projectSpec returns [String value] : PROJECT (s= singleSpec )+ ;
    public final String projectSpec() throws RecognitionException {
        String value = null;

        String s = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:90:2: ( PROJECT (s= singleSpec )+ )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:90:4: PROJECT (s= singleSpec )+
            {
            match(input,PROJECT,FOLLOW_PROJECT_in_projectSpec175); 
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:90:12: (s= singleSpec )+
            int cnt5=0;
            loop5:
            do {
                int alt5=2;
                switch ( input.LA(1) ) {
                case CHARSTRING1:
                case CHARSTRING2:
                case DOUBLE:
                case INT:
                    {
                    alt5=1;
                    }
                    break;

                }

                switch (alt5) {
            	case 1 :
            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:90:14: s= singleSpec
            	    {
            	    pushFollow(FOLLOW_singleSpec_in_projectSpec183);
            	    s=singleSpec();

            	    state._fsp--;

            	     projects.add(ParserHelpers.translateField(s,adaptor)); 

            	    }
            	    break;

            	default :
            	    if ( cnt5 >= 1 ) break loop5;
                        EarlyExitException eee =
                            new EarlyExitException(5, input);
                        throw eee;
                }
                cnt5++;
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "projectSpec"


    // $ANTLR start "singleSpec"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:93:1: singleSpec returns [String value] : i= index (ml= modifierList )? ;
    public final String singleSpec() throws RecognitionException {
        String value = null;

        String i = null;

        ArrayList<String> ml = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:94:2: (i= index (ml= modifierList )? )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:94:4: i= index (ml= modifierList )?
            {
            pushFollow(FOLLOW_index_in_singleSpec206);
            i=index();

            state._fsp--;

            value = i; 
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:95:3: (ml= modifierList )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case SLASH:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:95:5: ml= modifierList
                    {
                    pushFollow(FOLLOW_modifierList_in_singleSpec219);
                    ml=modifierList();

                    state._fsp--;

                     
                    				for(String s : ml)
                    					if(s.toLowerCase().equals(this.DISTINCT))
                    							distincts.add(ParserHelpers.translateField(i,adaptor));
                    			

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "singleSpec"


    // $ANTLR start "cqlQuery"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:104:1: cqlQuery returns [QueryBuilder qb] : sc= scopedClause ;
    public final QueryBuilder cqlQuery() throws RecognitionException {
        QueryBuilder qb = null;

        QueryBuilder sc = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:106:2: (sc= scopedClause )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:106:4: sc= scopedClause
            {
            pushFollow(FOLLOW_scopedClause_in_cqlQuery251);
            sc=scopedClause();

            state._fsp--;

             qb = sc; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return qb;
    }
    // $ANTLR end "cqlQuery"


    // $ANTLR start "scopedClause"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:113:1: scopedClause returns [QueryBuilder qb] : s1= searchClause (b= booleanGroup s2= searchClause )* ;
    public final QueryBuilder scopedClause() throws RecognitionException {
        QueryBuilder qb = null;

        ToXContent s1 = null;

        String b = null;

        ToXContent s2 = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:114:2: (s1= searchClause (b= booleanGroup s2= searchClause )* )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:114:4: s1= searchClause (b= booleanGroup s2= searchClause )*
            {
            pushFollow(FOLLOW_searchClause_in_scopedClause274);
            s1=searchClause();

            state._fsp--;

             
            			count = 0;
            			if(s1 instanceof FilterBuilder)
            			{
            				qb = QueryBuilders.constantScoreQuery((FilterBuilder)s1);
            			}
            			else
            			{
            				qb = (QueryBuilder)s1;
            			}
            		
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:126:3: (b= booleanGroup s2= searchClause )*
            loop7:
            do {
                int alt7=2;
                switch ( input.LA(1) ) {
                case AND:
                case OR:
                case NOT:
                case PROX:
                    {
                    alt7=1;
                    }
                    break;

                }

                switch (alt7) {
            	case 1 :
            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:126:4: b= booleanGroup s2= searchClause
            	    {
            	    pushFollow(FOLLOW_booleanGroup_in_scopedClause287);
            	    b=booleanGroup();

            	    state._fsp--;

            	    pushFollow(FOLLOW_searchClause_in_scopedClause293);
            	    s2=searchClause();

            	    state._fsp--;


            	    				count++;
            	    				if(b.equals("AND"))
            	    				{
            	    					if(s2 instanceof FilterBuilder)
            	    					{
            	    						qb = QueryBuilders.filteredQuery(qb, (FilterBuilder)s2);
            	    					}
            	    					else if (s1 instanceof FilterBuilder && count == 1)
            	    					{
            	    						qb = QueryBuilders.filteredQuery((QueryBuilder)s2, (FilterBuilder)s1);
            	    					}
            	    					else
            	    					{
            	    						qb = ParserHelpers.getCombinedQuery(qb, (QueryBuilder)s2);
            	    					}	
            	    				}
            	    				else if(b.equals("OR"))
            	    				{
            	    					if(s2 instanceof FilterBuilder)
            	    					{
            	    						qb = QueryBuilders.boolQuery().should(qb).should(QueryBuilders.constantScoreQuery((FilterBuilder)s2)).minimumNumberShouldMatch(1);
            	    					}
            	    					else
            	    					{
            	    						qb = ParserHelpers.getCombinedOrQuery(qb, (QueryBuilder)s2);
            	    						//qb = QueryBuilders.boolQuery().should(qb).should((QueryBuilder)s2).minimumNumberShouldMatch(1);
            	    					}	
            	    				}
            	    				else if(b.equals("NOT"))
            	    				{
            	    					if(s2 instanceof FilterBuilder)
            	    					{
            	    						qb = QueryBuilders.boolQuery().must(qb).mustNot(QueryBuilders.constantScoreQuery((FilterBuilder)s2));
            	    					}
            	    					else
            	    					{
            	    						qb = QueryBuilders.boolQuery().must(qb).mustNot((QueryBuilder)s2);
            	    					}	
            	    				}
            	    			

            	    }
            	    break;

            	default :
            	    break loop7;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return qb;
    }
    // $ANTLR end "scopedClause"


    // $ANTLR start "booleanGroup"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:171:1: booleanGroup returns [String value] : b= booleanOp ;
    public final String booleanGroup() throws RecognitionException {
        String value = null;

        String b = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:172:2: (b= booleanOp )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:172:4: b= booleanOp
            {
            pushFollow(FOLLOW_booleanOp_in_booleanGroup323);
            b=booleanOp();

            state._fsp--;

             
            				value = b;
            			

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "booleanGroup"


    // $ANTLR start "searchClause"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:184:1: searchClause returns [ToXContent qb] : ( LPAREN q= cqlQuery RPAREN | i= index r= relation s= searchTerm | s= searchTerm | d= distanceClause | o= overlapsClause );
    public final ToXContent searchClause() throws RecognitionException {
        ToXContent qb = null;

        QueryBuilder q = null;

        String i = null;

        String r = null;

        String s = null;

        GeoDistanceFilterBuilder d = null;

        GeoPolygonFilterBuilder o = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:185:2: ( LPAREN q= cqlQuery RPAREN | i= index r= relation s= searchTerm | s= searchTerm | d= distanceClause | o= overlapsClause )
            int alt8=5;
            switch ( input.LA(1) ) {
            case LPAREN:
                {
                alt8=1;
                }
                break;
            case CHARSTRING1:
            case CHARSTRING2:
                {
                switch ( input.LA(2) ) {
                case EQUALS:
                case GREATER:
                case LESS:
                case GEQUAL:
                case LEQUAL:
                case NOTEQUAL:
                case EXACT:
                case CHARSTRING1:
                case CHARSTRING2:
                    {
                    alt8=2;
                    }
                    break;
                case EOF:
                case SORTBY:
                case PROJECT:
                case RPAREN:
                case AND:
                case OR:
                case NOT:
                case PROX:
                    {
                    alt8=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 8, 2, input);

                    throw nvae;
                }

                }
                break;
            case DOUBLE:
                {
                switch ( input.LA(2) ) {
                case EQUALS:
                case GREATER:
                case LESS:
                case GEQUAL:
                case LEQUAL:
                case NOTEQUAL:
                case EXACT:
                case CHARSTRING1:
                case CHARSTRING2:
                    {
                    alt8=2;
                    }
                    break;
                case EOF:
                case SORTBY:
                case PROJECT:
                case RPAREN:
                case AND:
                case OR:
                case NOT:
                case PROX:
                    {
                    alt8=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 8, 3, input);

                    throw nvae;
                }

                }
                break;
            case INT:
                {
                switch ( input.LA(2) ) {
                case EQUALS:
                case GREATER:
                case LESS:
                case GEQUAL:
                case LEQUAL:
                case NOTEQUAL:
                case EXACT:
                case CHARSTRING1:
                case CHARSTRING2:
                    {
                    alt8=2;
                    }
                    break;
                case EOF:
                case SORTBY:
                case PROJECT:
                case RPAREN:
                case AND:
                case OR:
                case NOT:
                case PROX:
                    {
                    alt8=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 8, 4, input);

                    throw nvae;
                }

                }
                break;
            case DISTANCE:
                {
                alt8=4;
                }
                break;
            case OVERLAPS:
                {
                alt8=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:185:4: LPAREN q= cqlQuery RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_searchClause346); 
                    pushFollow(FOLLOW_cqlQuery_in_searchClause352);
                    q=cqlQuery();

                    state._fsp--;

                    match(input,RPAREN,FOLLOW_RPAREN_in_searchClause354); 
                     qb = q;	

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:186:4: i= index r= relation s= searchTerm
                    {
                    pushFollow(FOLLOW_index_in_searchClause365);
                    i=index();

                    state._fsp--;

                    pushFollow(FOLLOW_relation_in_searchClause371);
                    r=relation();

                    state._fsp--;

                    pushFollow(FOLLOW_searchTerm_in_searchClause377);
                    s=searchTerm();

                    state._fsp--;

                     
                    				String translated = ParserHelpers.translateField(i,adaptor);
                    				logger.info("Translated field " + i + " to: "+translated);
                    				if(s.equals("\"*\""))
                    				{
                    					qb = QueryBuilders.matchAllQuery();
                    				}
                    				else if(r.equals("=="))
                    				{
                    					qb = FilterBuilders.boolFilter().must(FilterBuilders.termFilter(i, s.replaceAll("\"","")));
                    				}
                    				else if(translated.toLowerCase().equals(ALLINDEXES))
                    				{
                    					qb = QueryBuilders.queryString(s);
                    				}
                    				else if(r.equals("="))
                    				{
                    					qb = QueryBuilders.queryString(translated + ":" + s);
                    				}
                    				else if(r.toLowerCase().equals("within"))
                    				{
                    					String[] range = s.replaceAll("\"","").split(" ");
                    					qb = QueryBuilders
                    		                    .rangeQuery(translated)
                    		                    .from(range[0].trim())
                    		                    .to(range[1].trim())
                    		                    .includeLower(true)
                    		                    .includeUpper(true);
                    				}
                    				else
                    				{
                    					qb = QueryBuilders.queryString(ParserHelpers.translateField(i,adaptor) + ":" + r + s);	
                    				}
                    				
                    				// if gDocCollectionID add it
                    				if(i.equals("gDocCollectionID"))
                    				{
                    					collections.add(s.replaceAll("\"",""));
                    				}
                    				
                    			

                    }
                    break;
                case 3 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:228:4: s= searchTerm
                    {
                    pushFollow(FOLLOW_searchTerm_in_searchClause392);
                    s=searchTerm();

                    state._fsp--;

                     qb = QueryBuilders.queryString(s); 

                    }
                    break;
                case 4 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:229:4: d= distanceClause
                    {
                    pushFollow(FOLLOW_distanceClause_in_searchClause403);
                    d=distanceClause();

                    state._fsp--;

                     qb = d; 

                    }
                    break;
                case 5 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:230:4: o= overlapsClause
                    {
                    pushFollow(FOLLOW_overlapsClause_in_searchClause414);
                    o=overlapsClause();

                    state._fsp--;

                     qb = o; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return qb;
    }
    // $ANTLR end "searchClause"


    // $ANTLR start "distanceClause"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:233:1: distanceClause returns [GeoDistanceFilterBuilder fb] : DISTANCE LPAREN i= index COMMA n= num COMMA g= geoPoint RPAREN ;
    public final GeoDistanceFilterBuilder distanceClause() throws RecognitionException {
        GeoDistanceFilterBuilder fb = null;

        String i = null;

        String n = null;

        Point g = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:234:2: ( DISTANCE LPAREN i= index COMMA n= num COMMA g= geoPoint RPAREN )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:234:4: DISTANCE LPAREN i= index COMMA n= num COMMA g= geoPoint RPAREN
            {
            match(input,DISTANCE,FOLLOW_DISTANCE_in_distanceClause432); 
            match(input,LPAREN,FOLLOW_LPAREN_in_distanceClause434); 
            pushFollow(FOLLOW_index_in_distanceClause440);
            i=index();

            state._fsp--;

            match(input,COMMA,FOLLOW_COMMA_in_distanceClause442); 
            pushFollow(FOLLOW_num_in_distanceClause448);
            n=num();

            state._fsp--;

            match(input,COMMA,FOLLOW_COMMA_in_distanceClause450); 
            pushFollow(FOLLOW_geoPoint_in_distanceClause456);
            g=geoPoint();

            state._fsp--;

            match(input,RPAREN,FOLLOW_RPAREN_in_distanceClause458); 

            			fb = FilterBuilders.geoDistanceFilter(i)
            					.optimizeBbox("memory")
            					.geoDistance(GeoDistance.ARC)
            					.point(g.getX(), g.getY())
            					.distance(Double.parseDouble(n), DistanceUnit.METERS);
            		

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return fb;
    }
    // $ANTLR end "distanceClause"


    // $ANTLR start "overlapsClause"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:244:1: overlapsClause returns [GeoPolygonFilterBuilder fb] : OVERLAPS LPAREN i= index COMMA g= geoPointList RPAREN ;
    public final GeoPolygonFilterBuilder overlapsClause() throws RecognitionException {
        GeoPolygonFilterBuilder fb = null;

        String i = null;

        ArrayList<Point> g = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:245:2: ( OVERLAPS LPAREN i= index COMMA g= geoPointList RPAREN )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:245:4: OVERLAPS LPAREN i= index COMMA g= geoPointList RPAREN
            {
            match(input,OVERLAPS,FOLLOW_OVERLAPS_in_overlapsClause478); 
            match(input,LPAREN,FOLLOW_LPAREN_in_overlapsClause480); 
            pushFollow(FOLLOW_index_in_overlapsClause486);
            i=index();

            state._fsp--;

            match(input,COMMA,FOLLOW_COMMA_in_overlapsClause488); 
            pushFollow(FOLLOW_geoPointList_in_overlapsClause494);
            g=geoPointList();

            state._fsp--;

            match(input,RPAREN,FOLLOW_RPAREN_in_overlapsClause496); 
             
            			fb = FilterBuilders.geoPolygonFilter(i);
            			for(Point p : g)
            				fb = fb.addPoint(p.getX(), p.getY());
            		

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return fb;
    }
    // $ANTLR end "overlapsClause"


    // $ANTLR start "relation"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:253:1: relation returns [String value] : c= comparitor ;
    public final String relation() throws RecognitionException {
        String value = null;

        String c = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:254:2: (c= comparitor )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:254:4: c= comparitor
            {
            pushFollow(FOLLOW_comparitor_in_relation518);
            c=comparitor();

            state._fsp--;

             value = c; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "relation"


    // $ANTLR start "comparitor"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:262:1: comparitor returns [String value] : (c= comparitorSymbol | c= namedComparitor );
    public final String comparitor() throws RecognitionException {
        String value = null;

        String c = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:263:2: (c= comparitorSymbol | c= namedComparitor )
            int alt9=2;
            switch ( input.LA(1) ) {
            case EQUALS:
            case GREATER:
            case LESS:
            case GEQUAL:
            case LEQUAL:
            case NOTEQUAL:
            case EXACT:
                {
                alt9=1;
                }
                break;
            case CHARSTRING1:
            case CHARSTRING2:
                {
                alt9=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:263:4: c= comparitorSymbol
                    {
                    pushFollow(FOLLOW_comparitorSymbol_in_comparitor541);
                    c=comparitorSymbol();

                    state._fsp--;

                     value = c; 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:264:4: c= namedComparitor
                    {
                    pushFollow(FOLLOW_namedComparitor_in_comparitor552);
                    c=namedComparitor();

                    state._fsp--;

                     value = c; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "comparitor"


    // $ANTLR start "comparitorSymbol"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:267:1: comparitorSymbol returns [String value] : (c= EQUALS | c= GREATER | c= LESS | c= GEQUAL | c= LEQUAL | c= NOTEQUAL | c= EXACT );
    public final String comparitorSymbol() throws RecognitionException {
        String value = null;

        Token c=null;

        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:268:2: (c= EQUALS | c= GREATER | c= LESS | c= GEQUAL | c= LEQUAL | c= NOTEQUAL | c= EXACT )
            int alt10=7;
            switch ( input.LA(1) ) {
            case EQUALS:
                {
                alt10=1;
                }
                break;
            case GREATER:
                {
                alt10=2;
                }
                break;
            case LESS:
                {
                alt10=3;
                }
                break;
            case GEQUAL:
                {
                alt10=4;
                }
                break;
            case LEQUAL:
                {
                alt10=5;
                }
                break;
            case NOTEQUAL:
                {
                alt10=6;
                }
                break;
            case EXACT:
                {
                alt10=7;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:268:4: c= EQUALS
                    {
                    c=(Token)match(input,EQUALS,FOLLOW_EQUALS_in_comparitorSymbol572); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:269:4: c= GREATER
                    {
                    c=(Token)match(input,GREATER,FOLLOW_GREATER_in_comparitorSymbol583); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 3 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:270:4: c= LESS
                    {
                    c=(Token)match(input,LESS,FOLLOW_LESS_in_comparitorSymbol594); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 4 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:271:4: c= GEQUAL
                    {
                    c=(Token)match(input,GEQUAL,FOLLOW_GEQUAL_in_comparitorSymbol605); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 5 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:272:4: c= LEQUAL
                    {
                    c=(Token)match(input,LEQUAL,FOLLOW_LEQUAL_in_comparitorSymbol616); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 6 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:273:4: c= NOTEQUAL
                    {
                    c=(Token)match(input,NOTEQUAL,FOLLOW_NOTEQUAL_in_comparitorSymbol627); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;
                case 7 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:274:4: c= EXACT
                    {
                    c=(Token)match(input,EXACT,FOLLOW_EXACT_in_comparitorSymbol638); 
                     value = (c!=null?c.getText():null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "comparitorSymbol"


    // $ANTLR start "namedComparitor"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:277:1: namedComparitor returns [String value] : nc= identifier ;
    public final String namedComparitor() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.identifier_return nc = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:278:2: (nc= identifier )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:278:4: nc= identifier
            {
            pushFollow(FOLLOW_identifier_in_namedComparitor658);
            nc=identifier();

            state._fsp--;

             value = (nc!=null?nc.value:null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "namedComparitor"


    // $ANTLR start "modifierList"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:281:1: modifierList returns [ArrayList<String> ml] : (m= modifier )+ ;
    public final ArrayList<String> modifierList() throws RecognitionException {
        ArrayList<String> ml = null;

        String m = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:282:2: ( (m= modifier )+ )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:282:4: (m= modifier )+
            {
             ml = new ArrayList<String>(); 
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:282:39: (m= modifier )+
            int cnt11=0;
            loop11:
            do {
                int alt11=2;
                switch ( input.LA(1) ) {
                case SLASH:
                    {
                    alt11=1;
                    }
                    break;

                }

                switch (alt11) {
            	case 1 :
            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:282:41: m= modifier
            	    {
            	    pushFollow(FOLLOW_modifier_in_modifierList683);
            	    m=modifier();

            	    state._fsp--;

            	     ml.add(m); 

            	    }
            	    break;

            	default :
            	    if ( cnt11 >= 1 ) break loop11;
                        EarlyExitException eee =
                            new EarlyExitException(11, input);
                        throw eee;
                }
                cnt11++;
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ml;
    }
    // $ANTLR end "modifierList"


    // $ANTLR start "modifier"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:285:1: modifier returns [String value] : SLASH n= modifierName (s= comparitorSymbol m= modifierValue )? ;
    public final String modifier() throws RecognitionException {
        String value = null;

        String n = null;

        String s = null;

        String m = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:286:2: ( SLASH n= modifierName (s= comparitorSymbol m= modifierValue )? )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:286:4: SLASH n= modifierName (s= comparitorSymbol m= modifierValue )?
            {
            match(input,SLASH,FOLLOW_SLASH_in_modifier705); 
            pushFollow(FOLLOW_modifierName_in_modifier711);
            n=modifierName();

            state._fsp--;

             value = n; 
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:286:43: (s= comparitorSymbol m= modifierValue )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case EQUALS:
                case GREATER:
                case LESS:
                case GEQUAL:
                case LEQUAL:
                case NOTEQUAL:
                case EXACT:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:286:45: s= comparitorSymbol m= modifierValue
                    {
                    pushFollow(FOLLOW_comparitorSymbol_in_modifier721);
                    s=comparitorSymbol();

                    state._fsp--;

                    pushFollow(FOLLOW_modifierValue_in_modifier727);
                    m=modifierValue();

                    state._fsp--;

                     value += s + m; System.out.println("MOD: "+value);

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "modifier"


    // $ANTLR start "prefix"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:289:1: prefix returns [String value] : p= term ;
    public final String prefix() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.term_return p = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:290:2: (p= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:290:4: p= term
            {
            pushFollow(FOLLOW_term_in_prefix751);
            p=term();

            state._fsp--;

             value = (p!=null?p.value:null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "prefix"


    // $ANTLR start "uri"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:293:1: uri returns [String value] : u= term ;
    public final String uri() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.term_return u = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:294:2: (u= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:294:4: u= term
            {
            pushFollow(FOLLOW_term_in_uri771);
            u=term();

            state._fsp--;

             value = (u!=null?u.value:null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "uri"


    // $ANTLR start "modifierName"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:297:1: modifierName returns [String name] : mn= term ;
    public final String modifierName() throws RecognitionException {
        String name = null;

        ElasticSearchParserParser.term_return mn = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:298:2: (mn= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:298:4: mn= term
            {
            pushFollow(FOLLOW_term_in_modifierName792);
            mn=term();

            state._fsp--;

             name = (mn!=null?mn.value:null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "modifierName"


    // $ANTLR start "modifierValue"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:301:1: modifierValue returns [String value] : mv= term ;
    public final String modifierValue() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.term_return mv = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:302:2: (mv= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:302:4: mv= term
            {
            pushFollow(FOLLOW_term_in_modifierValue812);
            mv=term();

            state._fsp--;

             value = (mv!=null?mv.value:null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "modifierValue"


    // $ANTLR start "searchTerm"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:305:1: searchTerm returns [String value] : st= term ;
    public final String searchTerm() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.term_return st = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:306:2: (st= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:306:4: st= term
            {
            pushFollow(FOLLOW_term_in_searchTerm832);
            st=term();

            state._fsp--;

             value = (st!=null?st.value:null); logger.trace("searchTerm "+(st!=null?input.toString(st.start,st.stop):null));

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "searchTerm"


    // $ANTLR start "index"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:310:1: index returns [String value] : t= term ;
    public final String index() throws RecognitionException {
        String value = null;

        ElasticSearchParserParser.term_return t = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:311:2: (t= term )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:311:4: t= term
            {
            pushFollow(FOLLOW_term_in_index853);
            t=term();

            state._fsp--;

             value = (t!=null?t.value:null); logger.trace("index "+(t!=null?input.toString(t.start,t.stop):null));

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "index"

    public static class term_return extends ParserRuleReturnScope {
        public String value;
    };

    // $ANTLR start "term"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:315:1: term returns [String value] : (i= identifier | n= num );
    public final ElasticSearchParserParser.term_return term() throws RecognitionException {
        ElasticSearchParserParser.term_return retval = new ElasticSearchParserParser.term_return();
        retval.start = input.LT(1);

        ElasticSearchParserParser.identifier_return i = null;

        String n = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:316:2: (i= identifier | n= num )
            int alt13=2;
            switch ( input.LA(1) ) {
            case CHARSTRING1:
            case CHARSTRING2:
                {
                alt13=1;
                }
                break;
            case DOUBLE:
            case INT:
                {
                alt13=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:316:4: i= identifier
                    {
                    pushFollow(FOLLOW_identifier_in_term874);
                    i=identifier();

                    state._fsp--;

                     retval.value = (i!=null?i.value:null); logger.trace("term "+(i!=null?input.toString(i.start,i.stop):null));

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:317:4: n= num
                    {
                    pushFollow(FOLLOW_num_in_term885);
                    n=num();

                    state._fsp--;

                    retval.value = n.toString(); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "term"

    public static class identifier_return extends ParserRuleReturnScope {
        public String value;
    };

    // $ANTLR start "identifier"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:321:1: identifier returns [String value] : i= ( CHARSTRING1 | CHARSTRING2 ) ;
    public final ElasticSearchParserParser.identifier_return identifier() throws RecognitionException {
        ElasticSearchParserParser.identifier_return retval = new ElasticSearchParserParser.identifier_return();
        retval.start = input.LT(1);

        Token i=null;

        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:322:2: (i= ( CHARSTRING1 | CHARSTRING2 ) )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:322:4: i= ( CHARSTRING1 | CHARSTRING2 )
            {
            i=(Token)input.LT(1);
            if ( (input.LA(1)>=CHARSTRING1 && input.LA(1)<=CHARSTRING2) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             retval.value = (i!=null?i.getText():null); logger.trace("identifier "+(i!=null?i.getText():null));

            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "identifier"


    // $ANTLR start "booleanOp"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:326:1: booleanOp returns [String op] : ( AND | OR | NOT | PROX );
    public final String booleanOp() throws RecognitionException {
        String op = null;

        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:327:2: ( AND | OR | NOT | PROX )
            int alt14=4;
            switch ( input.LA(1) ) {
            case AND:
                {
                alt14=1;
                }
                break;
            case OR:
                {
                alt14=2;
                }
                break;
            case NOT:
                {
                alt14=3;
                }
                break;
            case PROX:
                {
                alt14=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;
            }

            switch (alt14) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:327:4: AND
                    {
                    match(input,AND,FOLLOW_AND_in_booleanOp932); 
                     op = "AND"; 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:328:4: OR
                    {
                    match(input,OR,FOLLOW_OR_in_booleanOp940); 
                     op = "OR"; 

                    }
                    break;
                case 3 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:329:4: NOT
                    {
                    match(input,NOT,FOLLOW_NOT_in_booleanOp949); 
                     op = "NOT"; 

                    }
                    break;
                case 4 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:330:4: PROX
                    {
                    match(input,PROX,FOLLOW_PROX_in_booleanOp957); 
                     op = "PROX"; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "booleanOp"


    // $ANTLR start "geoPointList"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:333:1: geoPointList returns [ArrayList<Point> gps] : LBRACK g1= geoPoint ( COMMA g2= geoPoint )* RBRACK ;
    public final ArrayList<Point> geoPointList() throws RecognitionException {
        ArrayList<Point> gps = null;

        Point g1 = null;

        Point g2 = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:334:2: ( LBRACK g1= geoPoint ( COMMA g2= geoPoint )* RBRACK )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:334:4: LBRACK g1= geoPoint ( COMMA g2= geoPoint )* RBRACK
            {
            match(input,LBRACK,FOLLOW_LBRACK_in_geoPointList974); 
            pushFollow(FOLLOW_geoPoint_in_geoPointList980);
            g1=geoPoint();

            state._fsp--;

             
            				gps = new ArrayList<Point>();
            				gps.add(g1);
            			
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:339:3: ( COMMA g2= geoPoint )*
            loop15:
            do {
                int alt15=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt15=1;
                    }
                    break;

                }

                switch (alt15) {
            	case 1 :
            	    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:340:4: COMMA g2= geoPoint
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_geoPointList995); 
            	    pushFollow(FOLLOW_geoPoint_in_geoPointList1001);
            	    g2=geoPoint();

            	    state._fsp--;


            	    				gps.add(g2);
            	    			

            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);

            match(input,RBRACK,FOLLOW_RBRACK_in_geoPointList1013); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return gps;
    }
    // $ANTLR end "geoPointList"


    // $ANTLR start "geoPoint"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:347:1: geoPoint returns [Point gp] : LBRACK lat= num COMMA lon= num RBRACK ;
    public final Point geoPoint() throws RecognitionException {
        Point gp = null;

        String lat = null;

        String lon = null;


        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:348:2: ( LBRACK lat= num COMMA lon= num RBRACK )
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:348:4: LBRACK lat= num COMMA lon= num RBRACK
            {
            match(input,LBRACK,FOLLOW_LBRACK_in_geoPoint1028); 
            pushFollow(FOLLOW_num_in_geoPoint1034);
            lat=num();

            state._fsp--;

            match(input,COMMA,FOLLOW_COMMA_in_geoPoint1036); 
            pushFollow(FOLLOW_num_in_geoPoint1042);
            lon=num();

            state._fsp--;

            match(input,RBRACK,FOLLOW_RBRACK_in_geoPoint1044); 
             gp = new PointImpl(Double.parseDouble(lat),Double.parseDouble(lon),SpatialContext.GEO); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return gp;
    }
    // $ANTLR end "geoPoint"


    // $ANTLR start "num"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:351:1: num returns [String number] : (d= DOUBLE | i= INT );
    public final String num() throws RecognitionException {
        String number = null;

        Token d=null;
        Token i=null;

        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:352:2: (d= DOUBLE | i= INT )
            int alt16=2;
            switch ( input.LA(1) ) {
            case DOUBLE:
                {
                alt16=1;
                }
                break;
            case INT:
                {
                alt16=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;
            }

            switch (alt16) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:352:4: d= DOUBLE
                    {
                    d=(Token)match(input,DOUBLE,FOLLOW_DOUBLE_in_num1065); 
                     number = (d!=null?d.getText():null); 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:353:7: i= INT
                    {
                    i=(Token)match(input,INT,FOLLOW_INT_in_num1079); 
                     number = (i!=null?i.getText():null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return number;
    }
    // $ANTLR end "num"


    // $ANTLR start "order"
    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:356:1: order returns [String value] : ( ASC | DESC );
    public final String order() throws RecognitionException {
        String value = null;

        try {
            // org/gcube/elasticsearch/parser/ElasticSearchParser.g:357:2: ( ASC | DESC )
            int alt17=2;
            switch ( input.LA(1) ) {
            case ASC:
                {
                alt17=1;
                }
                break;
            case DESC:
                {
                alt17=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }

            switch (alt17) {
                case 1 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:357:4: ASC
                    {
                    match(input,ASC,FOLLOW_ASC_in_order1103); 
                     value = "ASC"; 

                    }
                    break;
                case 2 :
                    // org/gcube/elasticsearch/parser/ElasticSearchParser.g:358:4: DESC
                    {
                    match(input,DESC,FOLLOW_DESC_in_order1111); 
                     value = "DESC"; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "order"

    // Delegated rules


 

    public static final BitSet FOLLOW_TWODOUBLEQUOTES_in_esQuery67 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_esQuery69 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_scopedClause_in_esQuery81 = new BitSet(new long[]{0x0000000000000060L});
    public static final BitSet FOLLOW_sortSpec_in_esQuery89 = new BitSet(new long[]{0x0000000000000060L});
    public static final BitSet FOLLOW_projectSpec_in_esQuery102 = new BitSet(new long[]{0x0000000000000060L});
    public static final BitSet FOLLOW_EOF_in_esQuery111 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EOF_in_esQuery122 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SORTBY_in_sortSpec136 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_singleSpec_in_sortSpec146 = new BitSet(new long[]{0x00000000F0300002L});
    public static final BitSet FOLLOW_order_in_sortSpec154 = new BitSet(new long[]{0x0000000030300002L});
    public static final BitSet FOLLOW_PROJECT_in_projectSpec175 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_singleSpec_in_projectSpec183 = new BitSet(new long[]{0x0000000030300002L});
    public static final BitSet FOLLOW_index_in_singleSpec206 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_modifierList_in_singleSpec219 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_scopedClause_in_cqlQuery251 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause274 = new BitSet(new long[]{0x0000000003C00002L});
    public static final BitSet FOLLOW_booleanGroup_in_scopedClause287 = new BitSet(new long[]{0x0000000030300A80L});
    public static final BitSet FOLLOW_searchClause_in_scopedClause293 = new BitSet(new long[]{0x0000000003C00002L});
    public static final BitSet FOLLOW_booleanOp_in_booleanGroup323 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAREN_in_searchClause346 = new BitSet(new long[]{0x0000000030300A80L});
    public static final BitSet FOLLOW_cqlQuery_in_searchClause352 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_RPAREN_in_searchClause354 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_index_in_searchClause365 = new BitSet(new long[]{0x000000000037F000L});
    public static final BitSet FOLLOW_relation_in_searchClause371 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause377 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_searchTerm_in_searchClause392 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_distanceClause_in_searchClause403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_overlapsClause_in_searchClause414 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DISTANCE_in_distanceClause432 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_LPAREN_in_distanceClause434 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_index_in_distanceClause440 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_COMMA_in_distanceClause442 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_num_in_distanceClause448 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_COMMA_in_distanceClause450 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_geoPoint_in_distanceClause456 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_RPAREN_in_distanceClause458 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OVERLAPS_in_overlapsClause478 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_LPAREN_in_overlapsClause480 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_index_in_overlapsClause486 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_COMMA_in_overlapsClause488 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_geoPointList_in_overlapsClause494 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_RPAREN_in_overlapsClause496 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_comparitor_in_relation518 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_comparitorSymbol_in_comparitor541 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_namedComparitor_in_comparitor552 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUALS_in_comparitorSymbol572 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GREATER_in_comparitorSymbol583 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LESS_in_comparitorSymbol594 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GEQUAL_in_comparitorSymbol605 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEQUAL_in_comparitorSymbol616 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOTEQUAL_in_comparitorSymbol627 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXACT_in_comparitorSymbol638 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_namedComparitor658 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modifier_in_modifierList683 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_SLASH_in_modifier705 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_modifierName_in_modifier711 = new BitSet(new long[]{0x000000000007F002L});
    public static final BitSet FOLLOW_comparitorSymbol_in_modifier721 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_modifierValue_in_modifier727 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_prefix751 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_uri771 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_modifierName792 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_modifierValue812 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_searchTerm832 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_term_in_index853 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_term874 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_num_in_term885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_identifier908 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AND_in_booleanOp932 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OR_in_booleanOp940 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_booleanOp949 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROX_in_booleanOp957 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACK_in_geoPointList974 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_geoPoint_in_geoPointList980 = new BitSet(new long[]{0x0000000008000400L});
    public static final BitSet FOLLOW_COMMA_in_geoPointList995 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_geoPoint_in_geoPointList1001 = new BitSet(new long[]{0x0000000008000400L});
    public static final BitSet FOLLOW_RBRACK_in_geoPointList1013 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACK_in_geoPoint1028 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_num_in_geoPoint1034 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_COMMA_in_geoPoint1036 = new BitSet(new long[]{0x0000000030300000L});
    public static final BitSet FOLLOW_num_in_geoPoint1042 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_RBRACK_in_geoPoint1044 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLE_in_num1065 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INT_in_num1079 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ASC_in_order1103 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DESC_in_order1111 = new BitSet(new long[]{0x0000000000000002L});

}