/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetsHelper {
    private static final Logger logger = LoggerFactory.getLogger(SnippetsHelper.class);
    private static final SnippetsComparator snippetsComparator = new SnippetsComparator();
    public static final String SNIPPET_TOKEN = "...";
    public static final List<String> NOT_HIGHLIGHTED_FIELDS = Arrays.asList("gDocCollectionID", "ObjectID", "gDocCollectionLang");
    private static Ordering<String> byLengthOrdering = new Ordering<String>(){

        public int compare(String left, String right) {
            return Ints.compare((int)left.length(), (int)right.length());
        }
    };

    public static String createSnippetString(SearchHit hit, int maxSnippetCount) {
        ArrayList<String> snippets = new ArrayList<String>();
        logger.trace("Creating snippets for hit : " + hit);
        for (Map.Entry snippet : hit.getHighlightFields().entrySet()) {
            try {
                for (Text text : ((HighlightField)snippet.getValue()).getFragments()) {
                    snippets.add(text.string().trim());
                }
            }
            catch (Exception e) {
                logger.warn("error processing snippet for : " + (String)snippet.getKey() + " with value " + snippet.getValue());
            }
        }
        logger.trace("snippets found : " + snippets);
        String snippet = SnippetsHelper.joinTop(snippets, SNIPPET_TOKEN, maxSnippetCount);
        logger.trace("snippets string : " + snippet);
        return snippet;
    }

    public static String joinTop(Iterable<String> list, String token, Integer count) {
        List newList = byLengthOrdering.greatestOf(list, count.intValue());
        String snippet = Joiner.on((String)token).join((Iterable)newList);
        return snippet;
    }

    private static class SnippetsComparator
    implements Comparator<String> {
        private SnippetsComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o2.length() - o1.length();
        }
    }
}

