/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.node.Node;
import org.gcube.elasticsearch.NodeExecutor;
import org.gcube.elasticsearch.filters.Stopwords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FullTextNode.class);
    private static final long RSTIMEOUT = 30L;
    private static final int CLUSTER_HEALTH_YELLOW_TIMEOUT = 25;
    private static final int CLUSTER_HEALTH_GREEN_TIMEOUT = 5;
    private static final int DEFAULT_MAX_RESULTS = 50;
    private static Integer BULKREQUEST_SIZE = 2000;
    private static Integer BULKREQUEST_TIMEOUT = 300000;
    private static Integer DEFAULT_NUM_OF_SHARDS = 5;
    private static Integer MAX_FRAGMENT_CNT = 5;
    private static Integer MAX_FRAGMENT_SIZE = 150;
    private static String DEFAULT_DATADIR = ".";
    public static String META_INDEX = "meta-index";
    public static String ALL_INDEXES = "allIndexes";
    public static String DEFAULT_ANALYZER = "simple";
    public static String KEYWORD_ANALYZER = "keyword";
    private Client indexClient;
    private Node indexNode;
    private String clusterName;
    private String defaultIndexName;
    private Integer noOfShards;
    private Integer maxResults;
    private String scope;
    private Integer maxFragmentCnt;
    private Integer maxFragmentSize;
    private String dataDir;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private String hostname;

    public FullTextNode(Builder builder) throws InterruptedException {
        this.hostname = builder.hostname;
        this.clusterName = builder.clusterName;
        this.noOfShards = builder.noOfShards;
        this.scope = builder.scope;
        this.maxFragmentCnt = builder.maxFragmentCnt;
        this.maxFragmentSize = builder.maxFragmentSize;
        this.dataDir = builder.dataDir;
        this.maxResults = builder.maxResults;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.defaultIndexName;
    }

    public Integer getNoOfShards() {
        return this.noOfShards;
    }

    public String getScope() {
        return this.scope;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public Integer getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public Client getIndexClient() {
        return this.indexClient;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FullTextNode [indexNode=").append(this.indexNode).append(", cache=").append(", clusterName=").append(this.clusterName).append(", indexName=").append(this.defaultIndexName).append(", noOfShards=").append(this.noOfShards).append(", maxFragmentCnt=").append(this.maxFragmentCnt).append(", maxFragmentSize=").append(this.maxFragmentSize).append("]");
        return builder.toString();
    }

    public void createOrJoinCluster(Set<String> serviceEndpoints) throws InterruptedException {
        logger.info("Creating or joining cluster");
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_shards : " + this.noOfShards);
        logger.info("path.data : " + this.dataDir);
        Settings.Builder builder = Settings.settingsBuilder().put(this.getESCreateSetting());
        HashSet<String> hosts = new HashSet<String>();
        for (String serviceEndpoint : serviceEndpoints) {
            try {
                hosts.add(new URL(serviceEndpoint).getHost());
            }
            catch (MalformedURLException e) {
                logger.debug("Could not parse the hostname of " + serviceEndpoint + " - Will not be added to the cluster");
            }
        }
        logger.info("Found during initialization the following elastic search nodes: " + Arrays.toString(hosts.toArray(new String[0])));
        builder.put("discovery.zen.ping.multicast.ping.enabled", false).put("discovery.zen.ping.multicast.enabled", false).put("network.host", "_global_").put("discovery.zen.minimum_master_nodes", hosts.size() > 2 ? hosts.size() / 2 + 1 : 1).put("discovery.zen.ping.unicast.enabled", true);
        if (hosts.size() > 0) {
            builder.put("discovery.zen.ping.unicast.hosts", String.join((CharSequence)",", hosts));
        } else {
            logger.debug("Could not find any index service nodes on I.S to unicast. Not even myself. I will listen for others who might want to connect with me");
        }
        Settings settings = builder.build();
        NodeExecutor nodeExecutor = new NodeExecutor(this.clusterName, settings);
        Future<Client> future = this.executorService.submit(nodeExecutor);
        while (!future.isDone()) {
            Thread.sleep(1L);
        }
        try {
            this.indexClient = future.get();
        }
        catch (ExecutionException e) {
            logger.error("Could not initiate index client");
        }
        this.smartUpdateReplication();
    }

    public void stopAndCloseNode() {
        this.indexNode.close();
    }

    public void smartUpdateReplication() {
        ClusterAdminClient adminClient = this.indexClient.admin().cluster();
        ClusterHealthResponse clusterHealth = (ClusterHealthResponse)adminClient.prepareHealth(new String[0]).get();
        int newReplFactor = clusterHealth.getNumberOfDataNodes() - 1;
        IndicesAdminClient iac = this.indexClient.admin().indices();
        HashSet indices = new HashSet();
        clusterHealth.getIndices().values().forEach(clusterIndexHealth -> indices.add(clusterIndexHealth.getIndex()));
        UpdateSettingsRequest indexUpdateReq = new UpdateSettingsRequest(Settings.builder().put("index.number_of_replicas", newReplFactor).build(), (String[])indices.stream().toArray(String[]::new));
        iac.updateSettings(indexUpdateReq);
    }

    private void waitClusterState() {
        logger.info("will wait for 5 seconds until the cluster status turns to green");
        try {
            this.indexClient.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().get(TimeValue.timeValueSeconds((long)5L));
            logger.info("cluster status has turned to green");
        }
        catch (Exception e) {
            logger.info("Cluster state did not turn to green. Will wait for 25 seconds until the cluster status turns to yellow");
            try {
                this.indexClient.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().get(TimeValue.timeValueSeconds((long)25L));
                logger.info("cluster status has turned to yellow");
            }
            catch (Exception ex) {
                logger.warn("Error while waiting for the status to turn yellow. If this node was the first (or one of the first nodes) that hold an index with multiple shards this error is expected, since the 1st node might hold part of the index. If one of the last nodes reports this error then the index is unstable");
            }
        }
    }

    public void createIndex(String index2create) throws FileNotFoundException, IOException {
        Settings indexSettings = Settings.settingsBuilder().loadFromSource(XContentFactory.jsonBuilder().startObject().startObject("analysis").startObject("analyzer").startObject("steak").field("type", "standard").field("tokenizer", "standard").field("stopwords", Arrays.toString(Stopwords.getStopwords())).endObject().endObject().endObject().endObject().string()).build();
        CreateIndexRequest indexRequest = new CreateIndexRequest(index2create, indexSettings);
        this.indexClient.admin().indices().create(indexRequest).actionGet();
    }

    private void addStopwordsOnIndex(String index, String[] stopwords) throws IOException {
        UpdateSettingsResponse usr = (UpdateSettingsResponse)this.indexClient.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(Settings.settingsBuilder().loadFromSource(XContentFactory.jsonBuilder().startObject().startObject("analysis").startObject("analyzer").startObject("steak").field("type", "standard").field("tokenizer", "standard").field("stopwords", Arrays.toString(stopwords)).endObject().endObject().endObject().endObject().string())).execute().actionGet();
    }

    private Settings getESCreateSetting() {
        Settings.Builder builder = Settings.builder().put("path.home", "./").put("index.number_of_shards", this.noOfShards.intValue()).put("http.cors.enabled", true).put("http.cors.allow-origin", "*").put("path.data", this.dataDir);
        Settings settings = builder.build();
        return settings;
    }

    public ArrayList<String> getAllCollections() {
        return Lists.newArrayList((Object[])((ClusterStateResponse)this.indexClient.admin().cluster().prepareState().execute().actionGet()).getState().getMetaData().concreteAllIndices());
    }

    public IndexResponse addRecord(String collectionID, String recordID, String recordJSON) {
        IndexRequestBuilder req = this.indexClient.prepareIndex(collectionID, "gcube", recordID).setSource(recordJSON);
        return (IndexResponse)req.get();
    }

    public IndexResponse addRecord(String collectionID, String recordJSON) {
        IndexRequestBuilder req = this.indexClient.prepareIndex(collectionID, "gcube").setSource(recordJSON);
        return (IndexResponse)req.get();
    }

    public void close() {
        this.indexClient.close();
        this.indexNode.close();
        try {
            this.executorService.shutdown();
        }
        catch (Exception e) {
            logger.warn("error while closing executor service");
        }
    }

    static /* synthetic */ Integer access$000() {
        return DEFAULT_NUM_OF_SHARDS;
    }

    static /* synthetic */ Integer access$100() {
        return MAX_FRAGMENT_CNT;
    }

    static /* synthetic */ Integer access$200() {
        return MAX_FRAGMENT_SIZE;
    }

    static /* synthetic */ String access$300() {
        return DEFAULT_DATADIR;
    }

    public static class Builder {
        String hostname;
        String clusterName;
        Integer noOfShards = FullTextNode.access$000();
        String scope;
        Integer maxFragmentCnt = FullTextNode.access$100();
        Integer maxFragmentSize = FullTextNode.access$200();
        String dataDir = FullTextNode.access$300();
        Integer maxResults = 50;
        String configDir;

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder dataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder configDir(String configDir) {
            this.configDir = configDir;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder noOfShards(Integer noOfShards) {
            this.noOfShards = noOfShards;
            return this;
        }

        public Builder maxFragmentCnt(Integer maxFragmentCnt) {
            this.maxFragmentCnt = maxFragmentCnt;
            return this;
        }

        public Builder maxFragmentSize(Integer maxFragmentSize) {
            this.maxFragmentSize = maxFragmentSize;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public FullTextNode build() throws InterruptedException {
            if (this.hostname == null) {
                throw new IllegalStateException("hostname not given");
            }
            return new FullTextNode(this);
        }
    }
}

