package elasticsearchindex.components;
/*
 * LanguageIdPlugin.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: LanguageIdPlugin.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */




/**
 * This class loads the real implementation of the language id module.
 */
public interface LanguageIdPlugin {

	public static final String LANG_UNKNOWN = "unknown";
    /**
     * Initialise the language id plugin.
     * @param configFile          The config file.
     * @throws  IndexException    The exception thrown in case of failure
     */
    public void init(String configFile) throws IndexException;

    /**
     * Detect the language.
     * @param document            The document with the language to detect.
     * @return                    The detecetd language.
     * @throws  IndexException    The exception thrown in case of failure.
     */
    public String detectLanguage(String document) throws IndexException;
}
