/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex;

import elasticsearchindex.FTNodeCache;
import elasticsearchindex.components.FullTextIndexType;
import elasticsearchindex.components.IndexException;
import elasticsearchindex.components.IndexField;
import elasticsearchindex.helpers.ElasticSearchHelper;
import elasticsearchindex.helpers.QueryParser;
import elasticsearchindex.helpers.RowsetParser;
import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.contexts.GHNContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNode {
    private static final Logger logger = LoggerFactory.getLogger(FullTextNode.class);
    private static int DEFAULT_NUM_OF_REPLICAS = 0;
    private static int DEFAULT_NUM_OF_SHARDS = 1;
    private static int MAX_FRAGMENT_CNT = 5;
    private static int MAX_FRAGMENT_SIZE = 150;
    private static final long RSTIMEOUT = 5L;
    private static String ALL_INDEXES = "allIndexes";
    public static String META_INDEX = "meta-index";
    private Client indexClient;
    private Node indexNode;
    private Set<String> indexTypes = new HashSet<String>();
    private FTNodeCache cache;
    private String clusterName;
    private String indexName;
    private Integer noOfReplicas;
    private Integer noOfShards;
    private String scope;
    private int maxFragmentCnt;
    private int maxFragmentSize;
    private HashMap<String, FullTextIndexType> colForField = new HashMap();

    public FullTextNode() {
        logger.info("Initializing FullTextNode");
        this.cache = new FTNodeCache();
        this.initialize();
    }

    public FullTextNode(String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, int maxFragmentCnt, int maxFragmentSize) {
        this();
        this.clusterName = clusterName;
        this.indexName = indexName;
        this.noOfReplicas = noOfReplicas;
        this.noOfShards = noOfShards;
        this.scope = scope;
        this.maxFragmentCnt = maxFragmentCnt;
        this.maxFragmentSize = maxFragmentSize;
    }

    public FullTextNode(String clusterName, String indexName, String scope) {
        this();
        this.clusterName = clusterName;
        this.indexName = indexName;
        this.noOfReplicas = DEFAULT_NUM_OF_REPLICAS;
        this.noOfShards = DEFAULT_NUM_OF_SHARDS;
        this.scope = scope;
        this.maxFragmentCnt = MAX_FRAGMENT_CNT;
        this.maxFragmentSize = MAX_FRAGMENT_SIZE;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Integer getNoOfReplicas() {
        return this.noOfReplicas;
    }

    public Integer getNoOfShards() {
        return this.noOfShards;
    }

    public String getScope() {
        return this.scope;
    }

    public int getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public Client getIndexClient() {
        return this.indexClient;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FullTextNode [indexNode=").append(this.indexNode).append(", cache=").append(this.cache).append(", clusterName=").append(this.clusterName).append(", indexName=").append(this.indexName).append(", noOfReplicas=").append(this.noOfReplicas).append(", noOfShards=").append(this.noOfShards).append(", scope=").append(this.scope).append(", maxFragmentCnt=").append(this.maxFragmentCnt).append(", maxFragmentSize=").append(this.maxFragmentSize).append("]");
        return builder.toString();
    }

    public synchronized void addIndexType(String indexTypeStr) throws Exception {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        this.addIndexType(indexTypeStr, indexType);
    }

    public synchronized void addIndexType(String indexTypeStr, FullTextIndexType indexType) throws Exception {
        logger.info("Calling addIndexType");
        if (indexType == null) {
            logger.warn("IndexType is null");
            throw new Exception("Trying to null as IndexType. Check how you got it");
        }
        indexType = QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, this.scope, indexType, this.cache);
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{this.indexName}).execute().actionGet()).exists()) {
            logger.info("Index already exists");
        } else {
            CreateIndexResponse cir = (CreateIndexResponse)iac.prepareCreate(this.indexName).execute().actionGet();
            logger.info("Create Index Response : " + cir);
        }
        logger.info("Index Type");
        logger.info("-----------------------------------------------");
        logger.info(indexType.toString());
        logger.info("-----------------------------------------------");
        HashMap mapping = new HashMap();
        ArrayList<String> presentables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            String store;
            String string = store = idxTypeField.store ? "yes" : "no";
            String index = idxTypeField.index ? (idxTypeField.tokenize ? "analyzed" : "not_analyzed") : "no";
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID")) {
                index = "not_analyzed";
            }
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("type", "string");
            fieldMap.put("store", store);
            fieldMap.put("index", index);
            mapping.put(idxTypeField.name, fieldMap);
            if (!idxTypeField.returned || idxTypeField.name.equalsIgnoreCase("gDocCollectionID")) continue;
            presentables.add(idxTypeField.name);
        }
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        HashMap propertyMap = new HashMap();
        propertyMap.put("properties", mapping);
        HashMap mappingMap = new HashMap();
        mappingMap.put(indexTypeStr, propertyMap);
        String json = ElasticSearchHelper.createJSONObject(mappingMap).string();
        logger.info("json : " + json);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{this.indexName}).setType(indexTypeStr).setSource(json).execute().actionGet();
        logger.info("Update Settings Response : " + pmr.toString());
        this.indexTypes.add(indexTypeStr);
    }

    public void createOrJoinCluster() {
        logger.info("creating or joining cluster");
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).build();
        this.indexNode = NodeBuilder.nodeBuilder().settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public void joinCluster(Map<String, Integer> knownNodes) throws IOException {
        logger.info("joining cluster of known node : " + knownNodes);
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        String hosts = ElasticSearchHelper.createKnownHostsString(knownNodes);
        logger.info("hosts string : " + hosts);
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).put("discovery.zen.ping.multicast.ping.enabled", false).put("discovery.zen.ping.multicast.enabled", false).put("discovery.zen.ping.unicast.enabled", true).put("discovery.zen.ping.unicast.hosts", hosts).build();
        this.indexNode = NodeBuilder.nodeBuilder().settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public String query(String queryString) throws IndexException, GRS2WriterException {
        return this.query(queryString, -1);
    }

    public String query(String queryString, int maxHits) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        List<String> collIDs = QueryParser.getCollectionsIDFromQuery(queryString);
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(this.cache.indexTypesByCollIDs, collIDs, this.indexClient, this.indexName);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        final List<String> presentables = QueryParser.createPresentableForIndexTypes(this.cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        final List<String> projections = QueryParser.getProjectionsQueryFromQueryString(queryString);
        logger.info("projections of queryString : " + projections);
        String query = QueryParser.getLuceneQueryFromQueryString(queryString);
        logger.info("query part of queryString : " + query);
        final SearchHit[] hits = projections.contains("S") ? ElasticSearchHelper.queryElasticSearch(this.indexClient, this.indexName, query, maxHits, presentables, this.maxFragmentSize, this.maxFragmentCnt) : ElasticSearchHelper.queryElasticSearch(this.indexClient, this.indexName, query, maxHits);
        logger.info("Number of hits returned by index : " + hits.length);
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(presentables, projections);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + hits.length);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(hits.length)));
        final int max_fragmet_cnt = this.maxFragmentCnt;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    for (SearchHit hit : hits) {
                        if (!QueryParser.writeSearchHitInResultSet(hit, (RecordWriter<GenericRecord>)rsWriter, projections, presentables, max_fragmet_cnt, 5L)) break;
                    }
                    if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        rsWriter.close();
                    }
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
            }
        };
        new Thread(writerRun).start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public String queryStream(String queryString) throws IndexException, GRS2WriterException {
        return this.queryStream(queryString, -1);
    }

    public String queryStream(String queryString, final int maxHits) throws IndexException, GRS2WriterException {
        logger.info("queryString received : " + queryString);
        List<String> collIDs = QueryParser.getCollectionsIDFromQuery(queryString);
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(this.cache.indexTypesByCollIDs, collIDs, this.indexClient, this.indexName);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        final List<String> presentables = QueryParser.createPresentableForIndexTypes(this.cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        final List<String> projections = QueryParser.getProjectionsQueryFromQueryString(queryString);
        logger.info("projections of queryString : " + projections);
        final String query = QueryParser.getLuceneQueryFromQueryString(queryString);
        logger.info("query part of queryString : " + query);
        long numberOfHits = ElasticSearchHelper.queryCountElasticSearch(this.indexClient, this.indexName, query);
        if (maxHits > 0 && numberOfHits > (long)maxHits) {
            numberOfHits = maxHits;
        }
        logger.info("Number of hits returned by index : " + numberOfHits);
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(presentables, projections);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + numberOfHits);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(numberOfHits)));
        final Client client = this.indexClient;
        final String indexName = this.indexName;
        final int max_fragment_size = this.maxFragmentSize;
        final int max_fragment_cnt = this.maxFragmentCnt;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResponse scrollResp = projections.contains("S") ? ElasticSearchHelper.queryElasticSearchScroll(client, indexName, query, maxHits, presentables, max_fragment_size, max_fragment_cnt) : ElasticSearchHelper.queryElasticSearchScroll(client, indexName, query, maxHits);
                    int hits = 0;
                    do {
                        SearchHit hit;
                        scrollResp = ElasticSearchHelper.getNextSearchResponse(client, scrollResp);
                        logger.info("hits from scroll : " + scrollResp.hits().hits().length);
                        Iterator i$ = scrollResp.hits().iterator();
                        while (i$.hasNext() && QueryParser.writeSearchHitInResultSet(hit = (SearchHit)i$.next(), (RecordWriter<GenericRecord>)rsWriter, projections, presentables, max_fragment_cnt, 5L)) {
                        }
                        if (rsWriter.getStatus() == IBuffer.Status.Dispose) continue;
                        rsWriter.close();
                    } while (scrollResp.hits().hits().length != 0 && ++hits <= maxHits);
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
            }
        };
        new Thread(writerRun).start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public void deleteDocuments(List<String> docIDs) {
        ElasticSearchHelper.deleteDocuments(this.indexClient, this.indexName, docIDs);
    }

    public void commitMeta() {
        ElasticSearchHelper.commit(this.indexClient, META_INDEX);
    }

    public void commit() {
        ElasticSearchHelper.commit(this.indexClient, this.indexName);
    }

    public void clearIndex(String indexTypeName) {
        ElasticSearchHelper.clearIndex(this.indexClient, this.indexName, indexTypeName);
    }

    public void close() {
        this.indexClient.close();
        this.indexNode.close();
    }

    private void initialize() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(GHNContext.getContext().getHostname(), new ArrayList(), true));
        logger.info("Added hostname: " + GHNContext.getContext().getHostname());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public boolean feedRowset(String rowset) {
        HashMap<String, FullTextIndexType> colForIdTypes;
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        boolean status = this.feedRowset(bulkRequest, rowset, colForIdTypes = new HashMap<String, FullTextIndexType>());
        if (status) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            long after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.tookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.info("failures have happened");
            }
            this.commit();
        } else {
            logger.info("feedRowset failed");
        }
        return status;
    }

    public boolean feedLocator(String resultSetLocation) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.colForField);
    }

    public boolean feedLocator(String resultSetLocation, HashMap<String, FullTextIndexType> colForField) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        long after;
        logger.info("Initializing reader at resultset : " + resultSetLocation);
        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
        reader.setIteratorTimeout(5L);
        reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        int rowSetCount = 0;
        boolean success = true;
        long beforeFeed = System.currentTimeMillis();
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        try {
            logger.info("Initializing resultset reader iterator");
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.info("Getting result : " + rowSetCount);
                long before = System.currentTimeMillis();
                Record result = (Record)it.next();
                after = System.currentTimeMillis();
                logger.info("Time for getting record from Result Set : " + (double)(after - before) / 1000.0 + " secs");
                before = System.currentTimeMillis();
                String rowset = RowsetParser.getRowsetFromResult(result);
                after = System.currentTimeMillis();
                logger.info("Time for getting rowset from record : " + (double)(after - before) / 1000.0 + " secs");
                success = this.feedRowset(bulkRequest, rowset, colForField);
                if (!success) {
                    logger.info("feed rowset failed");
                    break;
                }
                logger.info("Result " + rowSetCount + " inserted");
                ++rowSetCount;
            }
        }
        catch (Exception e) {
            logger.info("Exception will feeding", (Throwable)e);
        }
        reader.close();
        if (success) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.tookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.info("failures have happened");
            }
            this.commit();
            this.updateManagerProperties(colForField);
        }
        logger.info("Total number of records feeded : " + rowSetCount);
        long afterFeed = System.currentTimeMillis();
        logger.info("Total insert time : " + (double)(afterFeed - beforeFeed) / 1000.0);
        System.out.println("Total insert time : " + (double)(afterFeed - beforeFeed) / 1000.0);
        return success;
    }

    private boolean feedRowset(BulkRequestBuilder bulkRequest, String rowset, HashMap<String, FullTextIndexType> colForIdTypes) {
        long before = System.currentTimeMillis();
        String rsIdxTypeID = RowsetParser.getIdxTypeNameRowset(this.indexName, rowset);
        long after = System.currentTimeMillis();
        logger.info("Time for getting rsIdxTypeID from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.info("Result IndexTypeID : " + rsIdxTypeID);
        before = System.currentTimeMillis();
        String lang = RowsetParser.getLangRowset(this.indexName, rowset);
        after = System.currentTimeMillis();
        logger.info("Time for getting lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.info("Result lang : " + lang);
        if (lang == null || lang.equals("")) {
            lang = "unknown";
        }
        before = System.currentTimeMillis();
        String colID = RowsetParser.getColIDRowset(this.indexName, rowset);
        after = System.currentTimeMillis();
        logger.info("Time for colID lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.info("Result colID : " + colID);
        if (colID == null || colID.equals("")) {
            logger.error("No collection ID given in ROWSET: " + rowset);
            return false;
        }
        try {
            this.addIndexType(rsIdxTypeID);
        }
        catch (Exception e) {
            logger.warn("Add index type exception", (Throwable)e);
            System.out.println("Add index type exception");
            e.printStackTrace();
            return false;
        }
        if (rsIdxTypeID == null || !this.indexTypes.contains(rsIdxTypeID)) {
            logger.error("IndexType : " + rsIdxTypeID + " not in indexTypes : " + this.indexTypes);
            return false;
        }
        before = System.currentTimeMillis();
        String alteredRowset = RowsetParser.preprocessRowset(rowset, lang, colID, this.indexName, rsIdxTypeID, this.scope, this.cache);
        after = System.currentTimeMillis();
        logger.info("Time for preprocessRowset : " + (double)(after - before) / 1000.0 + " secs");
        if (alteredRowset == null) {
            logger.error("could not preprocess rowset: " + rowset);
            return false;
        }
        before = System.currentTimeMillis();
        FullTextIndexType idxType = this.cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(rsIdxTypeID, this.scope));
        logger.info("index type for name : " + idxType);
        logger.info("all indexTypes in cache : " + this.cache.cachedIndexTypes.keySet());
        ElasticSearchHelper.insertRowSet(bulkRequest, this.indexClient, this.indexName, idxType, this.indexTypes, alteredRowset);
        after = System.currentTimeMillis();
        logger.info("Time for insertRowSet : " + (double)(after - before) / 1000.0 + " secs");
        colForIdTypes.put(colID + ":" + lang, idxType);
        return true;
    }

    private synchronized void bindIndexType(String indexTypeStr) {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        logger.info("Index Type");
        logger.info("-----------------------------------------------");
        logger.info(indexType.toString());
        logger.info("-----------------------------------------------");
        ArrayList<String> presentables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            if (!idxTypeField.returned || idxTypeField.name.equalsIgnoreCase("gDocCollectionID")) continue;
            presentables.add(idxTypeField.name);
        }
        this.indexTypes.add(indexTypeStr);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
    }

    private void getIndexTypesOfIndex() {
        ClusterStateResponse clusterResponse = (ClusterStateResponse)this.indexClient.admin().cluster().prepareState().execute().actionGet();
        logger.info("clusterResponse : " + clusterResponse);
        ImmutableMap mappings = clusterResponse.state().getMetaData().index(this.indexName).getMappings();
        logger.info("index types found in index : " + mappings.keySet());
        for (String indexType : mappings.keySet()) {
            logger.info("adding index type : " + indexType);
            try {
                this.bindIndexType(indexType);
                logger.info("adding index type : " + indexType + " succeded");
            }
            catch (Exception e) {
                logger.info("adding index type : " + indexType + " failed");
            }
        }
    }

    public boolean updateManagerProperties(HashMap<String, FullTextIndexType> colForIdTypes) {
        ArrayList fieldsToBeAdded;
        ArrayList collectionIdsToBeAdded;
        Map result = null;
        String id = null;
        long version = 0L;
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
                id = hit.getId();
                version = hit.getVersion();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet", (Throwable)e);
        }
        if (result != null) {
            collectionIdsToBeAdded = (ArrayList)result.get("collectionIDs");
            fieldsToBeAdded = (ArrayList)result.get("fields");
        } else {
            collectionIdsToBeAdded = new ArrayList();
            fieldsToBeAdded = new ArrayList();
        }
        Set<String> keys = colForIdTypes.keySet();
        for (String colIDandLang : keys) {
            IndexField[] fields;
            FullTextIndexType index = colForIdTypes.get(colIDandLang);
            for (IndexField field : fields = index.getFields()) {
                if (RowsetParser.addToFieldInfo(fieldsToBeAdded, field.name, colIDandLang, index)) continue;
                return false;
            }
            fieldsToBeAdded.add(colIDandLang + ":" + "s" + ":" + ALL_INDEXES);
            collectionIdsToBeAdded.add(colIDandLang);
        }
        HashSet hs1 = new HashSet();
        HashSet hs2 = new HashSet();
        hs1.addAll(collectionIdsToBeAdded);
        hs2.addAll(fieldsToBeAdded);
        collectionIdsToBeAdded.clear();
        fieldsToBeAdded.clear();
        collectionIdsToBeAdded.addAll(hs1);
        fieldsToBeAdded.addAll(hs2);
        try {
            HashMap<String, String[]> document = new HashMap<String, String[]>();
            document.put("collectionIDs", collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]));
            document.put("fields", fieldsToBeAdded.toArray(new String[fieldsToBeAdded.size()]));
            IndexRequestBuilder indexRequest = this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(ElasticSearchHelper.createJSONObject(document).string());
            if (result != null) {
                indexRequest.setVersion(++version);
            }
            indexRequest.execute();
            logger.info("Inserted colIDs and fields to " + META_INDEX);
            this.commitMeta();
        }
        catch (ElasticSearchException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        return true;
    }

    public boolean addMetaIndex() {
        int counter = 0;
        Map result = null;
        while (true) {
            try {
                SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                for (SearchHit hit : response.getHits().getHits()) {
                    result = hit.getSource();
                }
            }
            catch (Exception e) {
                logger.warn("Not initialized yet, retrying");
                ++counter;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("Failed to sleep", (Throwable)e);
                }
                if (counter != 10) continue;
                return false;
            }
            break;
        }
        if (result == null) {
            try {
                HashMap<String, String[]> document = new HashMap<String, String[]>();
                document.put("collectionIDs", new String[0]);
                document.put("fields", new String[0]);
                IndexRequestBuilder indexRequest = this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject(document).string());
                indexRequest.execute();
                logger.info("Added empty meta-index");
            }
            catch (IOException e) {
                logger.error("Failed to add meta index", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

