/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex.helpers;

import elasticsearchindex.components.FullTextIndexType;
import elasticsearchindex.components.IndexField;
import elasticsearchindex.components.XMLProfileParser;
import elasticsearchindex.helpers.QueryParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchHelper {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchHelper.class);
    private static long SCROLL_TIMEOUT = 100000L;
    private static List<String> NOT_HIGHLIGHTED_FIELDS = Arrays.asList("gDocCollectionID", "ObjectID", "gDocCollectionLang");
    private static Analyzer NoStopAnalyser = new StandardAnalyzer(Version.LUCENE_36);

    public static void commit(Client client, String indexName) {
        try {
            RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexName});
            logger.info("refresh request : " + refreshRequest);
            long before = System.currentTimeMillis();
            RefreshResponse refreshResponse = (RefreshResponse)client.admin().indices().refresh(refreshRequest).actionGet();
            long after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("refresh response failed shards : " + refreshResponse.getFailedShards());
            FlushRequest flushRequest = new FlushRequest(new String[]{indexName}).refresh(true);
            logger.info("flush request: " + flushRequest.toString());
            before = System.currentTimeMillis();
            FlushResponse flushResponse = (FlushResponse)client.admin().indices().flush(flushRequest).actionGet();
            after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("flush response  failed shards: " + flushResponse.getFailedShards());
        }
        catch (Exception e) {
            logger.error("Exception while commiting:", (Throwable)e);
        }
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, String queryString, int maxHits) {
        return ElasticSearchHelper.queryElasticSearch(client, indexName, queryString, maxHits, null, 0, 0);
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, String queryString, int maxHits, List<String> highlightedFields, int maxFragmentSize, int maxFragmentCnt) {
        queryString = "{\"query_string\" : { \"query\" : \"" + queryString + "\" }}";
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery(queryString);
        if (highlightedFields != null) {
            for (String hilightedField : highlightedFields) {
                if (NOT_HIGHLIGHTED_FIELDS.contains(hilightedField)) continue;
                srb.addHighlightedField(hilightedField, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
        }
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        logger.info("query request : " + srb.toString());
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        logger.info("query response : " + response);
        return response.hits().getHits();
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, String queryString, int maxHits) {
        return ElasticSearchHelper.queryElasticSearchScroll(client, indexName, queryString, maxHits, null, 0, 0);
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, String queryString, int maxHits, List<String> highlightedFields, int maxFragmentSize, int maxFragmentCnt) {
        queryString = "{\"query_string\" : { \"query\" : \"" + queryString + "\" }}";
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setTrackScores(true).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).setQuery(queryString);
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        if (highlightedFields != null) {
            for (String hilightedField : highlightedFields) {
                if (NOT_HIGHLIGHTED_FIELDS.contains(hilightedField)) continue;
                srb.addHighlightedField(hilightedField, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
        }
        logger.info("query request : " + srb.toString());
        SearchResponse scrollResponse = (SearchResponse)srb.execute().actionGet();
        logger.info("query response : " + scrollResponse);
        return scrollResponse;
    }

    public static long queryCountElasticSearch(Client client, String indexName, String queryString) {
        queryString = "{\"query_string\" : { \"query\" : \"" + queryString + "\" }}";
        CountRequestBuilder countRequest = client.prepareCount(new String[]{indexName}).setQuery(queryString.getBytes());
        logger.info("query request : " + countRequest.request());
        CountResponse countResponse = (CountResponse)countRequest.execute().actionGet();
        logger.info("query response : " + countResponse);
        return countResponse.getCount();
    }

    public static SearchResponse getNextSearchResponse(Client client, SearchResponse scrollResponse) {
        scrollResponse = (SearchResponse)client.prepareSearchScroll(scrollResponse.getScrollId()).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).execute().actionGet();
        logger.info("scroll response : " + scrollResponse);
        return scrollResponse;
    }

    public static void deleteDocuments(Client client, String indexName, List<String> docIDs) {
        logger.info("docIds to be deleted : " + docIDs);
        for (String docID : docIDs) {
            logger.info("deleting document with gDocCollectionID : " + docID);
            DeleteByQueryRequestBuilder requestBuilder = client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)docID));
            logger.info("delete request : " + requestBuilder.request());
            requestBuilder.execute().actionGet();
        }
        ElasticSearchHelper.commit(client, indexName);
    }

    public static void clearIndex(Client client, String indexName, String indexTypeName) {
        logger.info("index to be deleted : ");
        DeleteByQueryResponse dr = (DeleteByQueryResponse)client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setTypes(new String[]{indexTypeName}).execute().actionGet();
        logger.info("Delete response : " + dr.toString());
        ElasticSearchHelper.commit(client, indexName);
    }

    public static void insertSimple(String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchException, IOException {
        if (!allowedIndexTypes.contains(indexType)) {
            throw new ElasticSearchException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexResponse response = (IndexResponse)indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc).execute().actionGet();
        logger.info("indexResponse : " + response);
    }

    public static void insertBulk(BulkRequestBuilder bulkRequest, String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchException, IOException {
        if (!allowedIndexTypes.contains(indexType)) {
            throw new ElasticSearchException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexRequestBuilder indexRequest = indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc);
        bulkRequest.add(indexRequest);
        logger.info("indexRequest : " + indexRequest);
    }

    public static int insertRowSet(BulkRequestBuilder bulkRequest, Client client, String indexName, FullTextIndexType idxType, Set<String> allowedIndexTypes, String rowsetXML) {
        logger.info("indexName : " + indexName);
        logger.info("idxType : " + idxType.getIndexTypeName());
        logger.info("allowedIndexTypes : " + allowedIndexTypes);
        logger.info("rowsetXML : " + rowsetXML);
        int docCount = 0;
        try {
            XMLProfileParser XMLparser = new XMLProfileParser();
            XMLparser.readString(rowsetXML, null);
            XMLparser.setRootNode("ROWSET");
            while (XMLparser.setNextField()) {
                ++docCount;
                String[][] fieldData = XMLparser.getSubFields();
                if (fieldData == null) continue;
                HashMap<String, String> document = new HashMap<String, String>();
                for (IndexField idxTypeField : idxType.getFields()) {
                    StringBuilder fieldContentSum = new StringBuilder();
                    for (int ii = 0; ii < fieldData[0].length; ++ii) {
                        String baseName = fieldData[0][ii];
                        String fieldContents = fieldData[1][ii];
                        if (idxTypeField.name.equals(baseName) && fieldContents != null) {
                            fieldContentSum.append(fieldContents);
                            fieldContentSum.append(" ");
                            continue;
                        }
                        if (!QueryParser.isDescendant(baseName, idxTypeField) || fieldContents == null) continue;
                        fieldContentSum.append(fieldContents);
                        fieldContentSum.append(" ");
                    }
                    if (fieldContentSum.length() <= 0) continue;
                    document.put(idxTypeField.name, fieldContentSum.toString().trim());
                    logger.info("added field in document: " + idxTypeField.name + ", " + fieldContentSum);
                }
                for (int ii = 0; ii < fieldData[0].length; ++ii) {
                    if (!fieldData[0][ii].equalsIgnoreCase("ObjectID") || fieldData[1][ii] == null) continue;
                    String data = fieldData[1][ii];
                    HashMap<String, String> field = new HashMap<String, String>();
                    field.put("value", data);
                    field.put("store", "yes");
                    field.put("index", "analyzed");
                    document.put(fieldData[0][ii].toLowerCase(), data.trim());
                    logger.info("added field in document: " + fieldData[0][ii] + ", " + data);
                }
                logger.info("************* INSERT");
                ElasticSearchHelper.insertBulk(bulkRequest, ElasticSearchHelper.createJSONObject(document).string(), client, indexName, idxType.getIndexTypeName(), allowedIndexTypes);
            }
        }
        catch (Exception e) {
            logger.warn("Exception while inserting documents", (Throwable)e);
        }
        return docCount;
    }

    public static XContentBuilder createJSONObject(Map<String, ? extends Object> keyValues) throws IOException {
        XContentBuilder xcb = XContentFactory.jsonBuilder();
        xcb = xcb.startObject();
        for (Map.Entry<String, ? extends Object> keyvalue : keyValues.entrySet()) {
            xcb = xcb.field(keyvalue.getKey(), keyvalue.getValue());
        }
        return xcb.endObject();
    }

    public static String createKnownHostsString(Map<String, Integer> hosts) {
        boolean first = true;
        StringBuffer strBuf = new StringBuffer();
        for (Map.Entry<String, Integer> entry : hosts.entrySet()) {
            if (!first) {
                strBuf.append(", ");
                first = false;
            }
            strBuf.append(entry.getKey());
        }
        return strBuf.toString();
    }
}

