package org.gcube.forwardindexnode.client.library.beans;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class Types {
	// REQUEST AND RESPONSE ELEMENTS

	public static class StringArray
	{
		@XmlElement(name = "array")
		public List<String> array;
	}
	
	public static class KeyDescriptionType
	{
		@XmlElement(name = "IndexTypeID")
		public String IndexTypeID;
		
		@XmlElement(name = "KeyName")
		public String KeyName;
	}
	
	public static class KeyDescriptionArray
	{
		@XmlElement(name = "array")
		public List<KeyDescriptionType> array;
	}
	
	public static class GetIndexInformationResponse
	{
		@XmlElement(name = "IndexID")
		public String IndexID;
		
		@XmlElement(name = "CollectionID")
		public StringArray CollectionID;
		
		@XmlElement(name = "Fields")
		public StringArray Fields;
		
		@XmlElement(name = "KeyDescription")
		public KeyDescriptionArray KeyDescription;
		
		@XmlElement(name = "ContentType")
		public String ContentType;
	}
	
	public static class SetCollections
	{
		@XmlElement(name = "setCollections")
		public StringArray setCollections;
	}
	
	public static class SetFields
	{
		@XmlElement(name = "setFields")
		public StringArray setFields;
	}
	
	public static class CreateResource
	{
		@XmlElement(name = "IndexID")
		public String IndexID;
		
		@XmlElement(name = "CollectionID")
		public String[] CollectionID;

		@XmlElement(name = "KeyDescription")
		public KeyDescriptionArray KeyDescription;
		
		@XmlElement(name = "ContentType")
		public String ContentType;
		
		@XmlElement(name = "ClusterID")
		public String ClusterID;
	}
	
	public static class CreateResourceResponse
	{
		@XmlElement(name = "EndpointReference", namespace="http://schemas.xmlsoap.org/ws/2004/03/addressing")
		public W3CEndpointReference EndpointReference;
		
		@XmlElement(name = "IndexID")
		public String IndexID;
	}
	
	public static class Destroy{}
	
}
