package org.gcube.forwardindexnode.client.library.proxies;

import java.util.Arrays;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.forwardindexnode.client.library.exceptions.ForwardIndexNodeException;
import org.gcube.forwardindexnode.client.library.stubs.ForwardIndexNodeStub;
import org.gcube.forwardindexnode.client.library.beans.Types.Destroy;
import org.gcube.forwardindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.forwardindexnode.client.library.beans.Types.KeyDescriptionArray;
import org.gcube.forwardindexnode.client.library.beans.Types.StringArray;
import org.gcube.common.clients.Call;

public class ForwardIndexNodeCLDefaultProxy implements ForwardIndexNodeCLProxyI {

	private final ProxyDelegate<ForwardIndexNodeStub> delegate;

	public ForwardIndexNodeCLDefaultProxy(ProxyDelegate<ForwardIndexNodeStub> config) {
		this.delegate = config;
	}

	@Override
	public Boolean feedLocator(final String feedLocator) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.feedLocator(feedLocator);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}
	
	@Override
	public boolean deleteCollection(final String collectionID) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteCollection(collectionID);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public String query(final String query) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, String> call = new Call<ForwardIndexNodeStub, String>() {
			@Override
			public String call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean shutdown(final String shutdown) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.shutdown(shutdown);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean destroyNode() throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.destroyNode(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean refresh() throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.refresh(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean rebuildMetaIndex() throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.rebuildMetaIndex(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public GetIndexInformationResponse getIndexInformation() throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, GetIndexInformationResponse> call = new Call<ForwardIndexNodeStub, GetIndexInformationResponse>() {

			@Override
			public GetIndexInformationResponse call(ForwardIndexNodeStub endpoint) throws Exception {

				return endpoint.getIndexInformation(new Empty());
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean setCollections(final String[] collections) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(collections);
				return endpoint.setCollections(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean setFields(final String[] fields) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(fields);
				return endpoint.setFields(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}
	
	@Override
	public void destroy() throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Empty> call = new Call<ForwardIndexNodeStub, Empty>() {
			@Override
			public Empty call(ForwardIndexNodeStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean addKeyDescription(final KeyDescriptionArray keyDescriptionArray) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.addKeyDescription(keyDescriptionArray);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}

	@Override
	public boolean setKeyDescription(final KeyDescriptionArray keyDescriptionArray) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeStub, Boolean> call = new Call<ForwardIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(ForwardIndexNodeStub endpoint) throws Exception {
				return endpoint.setKeyDescription(keyDescriptionArray);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}
		

}
