package org.gcube.forwardindexnode.client.library.stubs;

import static org.gcube.forwardindexnode.client.library.utils.ForwardIndexNodeCLConstants.*;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.forwardindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.forwardindexnode.client.library.beans.Types.KeyDescriptionArray;
import org.gcube.forwardindexnode.client.library.beans.Types.StringArray;
import org.gcube.forwardindexnode.client.library.beans.Types.Destroy;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface ForwardIndexNodeStub {
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocator(String feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocatorUnit(String feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean flush(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String query(String query);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean deleteCollection(String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean shutdown(String shutdown);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean destroyNode(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean refresh(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean rebuildMetaIndex(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	GetIndexInformationResponse getIndexInformation(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setCollections(StringArray collections);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setFields(StringArray fields);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean addKeyDescription(KeyDescriptionArray keyDescriptionArray);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setKeyDescription(KeyDescriptionArray keyDescriptionArray);
	
	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	StringArray getCollectionsOfIndex(String indexName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	StringArray getIndicesOfCollection(String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Long collectionCount(String collectionID);
}
