package org.gcube.forwardindexnode.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.forwardindexnode.client.library.beans.Types.CreateResource;
import org.gcube.forwardindexnode.client.library.beans.Types.CreateResourceResponse;
import org.gcube.forwardindexnode.client.library.exceptions.ForwardIndexNodeException;
import org.gcube.forwardindexnode.client.library.stubs.ForwardIndexNodeFactoryStub;

public class ForwardIndexNodeFactoryCLDefaultProxy implements ForwardIndexNodeFactoryCLProxyI {

	private final ProxyDelegate<ForwardIndexNodeFactoryStub> delegate;

	public ForwardIndexNodeFactoryCLDefaultProxy(ProxyDelegate<ForwardIndexNodeFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final CreateResource createResource) throws ForwardIndexNodeException {
		Call<ForwardIndexNodeFactoryStub, CreateResourceResponse> call = new Call<ForwardIndexNodeFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(ForwardIndexNodeFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new ForwardIndexNodeException(e);
		}
	}
}
