package org.gcube.forwardindexnode.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.forwardindexnode.client.library.utils.ForwardIndexNodeCLConstants;

public class SourceQueryBuilder {

	private final StatefulQuery query;
	
	private String indexID;
	
	public SourceQueryBuilder(StatefulQuery query) {
		query.addNamespace("ns1",URI.create(ForwardIndexNodeCLConstants.NAMESPACE));
		this.query=query;
	}

	public SourceQueryBuilder withIndexID(String indexID) {
		this.indexID = indexID;
		return this;
	}

	public StatefulQuery build() {
		if (indexID!=null)
			query.addCondition("$resource/SourceKey/text() eq '" + indexID + "'");
		return query;
	}

}
