package org.gcube.index.forwardindexnode;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.couchbase.CouchBaseNode;
import org.gcube.couchbase.entities.MetaIndex;
import org.gcube.index.forwardindexnode.stubs.CreateResourceResponse;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodeFactoryPortType;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodePortType;
import org.gcube.index.forwardindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionArray;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionType;
import org.gcube.index.forwardindexnode.stubs.StringArray;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeServiceAddressingLocator;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardIndexNode extends GCUBEPortType {

	protected static final String FACTORY = "Factory";
	protected static final String SERVICE_NAME = "ForwardIndexNode";
	protected static final String SERVICE_CLASS = "Index";
	private static final String USE_CLUSTER_ID = "useClusterId";
	protected static final int TIMEOUT = 700000;

	private static final Logger logger = LoggerFactory.getLogger(ForwardIndexNode.class);

	private String clusterID = null;
	
	@Override
	protected void onReady() throws Exception {
		super.onReady();
	}

	/** {@inheritDoc} */
	protected ServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	public synchronized GetIndexInformationResponse getIndexInformation(VOID request) throws GCUBEFault {
		try {
			Resource managementResource = getResource();

			if (managementResource.isInitializing())
				throw new Exception("Resource is not initialized yet");

			GetIndexInformationResponse response = new GetIndexInformationResponse();
			response.setIndexID(managementResource.getIndexID());

			StringArray colStringArray = new StringArray();
			colStringArray.setArray(managementResource.getCollectionID());
			response.setCollectionID(colStringArray);

			StringArray fieldStringArray = new StringArray();
			fieldStringArray.setArray(managementResource.getFields());
			response.setFields(fieldStringArray);

			return response;
		} catch (Exception e) {
			logger.error("Exception", e);
			throw new GCUBEFault(e.getMessage());
		}
	}

	private void initializeClusterID()
	{
		if(clusterID==null)
		{
			try {
				logger.info("clusterID was null");
				clusterID = (String) getResource().getResourcePropertySet().get(Resource.RP_CLUSTER_ID).get(0);
				logger.info("after get resource clusterID is : " + clusterID);
			} catch (ResourceException e) {
				logger.error("Error while initializing cluster id",e);
			}
		}
		StatefulContext pctx = (StatefulContext) StatefulContext.getContext();
		boolean useClusterID = (Boolean) pctx.getProperty(USE_CLUSTER_ID);
		if (!useClusterID)
			clusterID = ServiceContext.getContext().getScope().toString();

	}
	
	public boolean feedLocator(String resultSetLocation) {
		initializeClusterID();
		final String fResultSetLocation = resultSetLocation;
		final String key = getResouceKey();
		logger.info("resource key in feeding : " + key);
		
		final CouchBaseNode couchbaseNode = getForwardNode();
		
		new Thread() {
			@Override
			public void run() {
				try {
					//final HashMap<String, ForwardIndexType> colForField = new HashMap<String, ForwardIndexType>();
					boolean result = couchbaseNode.feedLocator(fResultSetLocation);
					logger.info("Feeding completed, result was: " + result);
					if (result)
						updateManagerProperties(couchbaseNode);
					logger.info("Properties updating completed");
				} catch (Exception e) {
					logger.error("Exception", e);
				}
			}
		}.start();
		return true;
	}

	public String query(String queryString) {
		logger.info("Query : " + queryString);
		initializeClusterID();
		try {
			return getForwardNode().query(queryString);
		} catch (Exception e) {
			logger.error("Exception", e);
			return "Caught Exception " + e.getMessage();
		}
	}

	public boolean shutdown(String nothing) {
		initializeClusterID();
		try {
			if (nothing != null && nothing.trim().equalsIgnoreCase("DELETE")){
				getForwardNode().delete();
				updateManagerProperties(getForwardNode());
			}

			getForwardNode().shutdown();
			return true;
		} catch (Exception e) {
			logger.error("Exception", e);
			return false;
		}
	}
	
	public boolean destroyNode(VOID voidType)  {
		initializeClusterID();
		
		boolean hasFailed = false;
		HashMap<String, Set<String>> endpoints = discoverFulltextIndexNodes(Arrays.asList(getForwardNodeClientScope()), clusterID);
		
		logger.info("Found endpoints to shutdown " + endpoints);
		
		logger.info("Deleting indices...");
		try {
			getForwardNode().delete();
		} catch (Exception e) {
			logger.error("Error deleting the indices...", e);
			return false;
		}
		logger.info("Deleting indices DONE");
		
		GCUBEScope scope = GCUBEScope.getScope(getForwardNodeClientScope());
		
		for (String endpoint : endpoints.keySet()) {
			for (String key : endpoints.get(endpoint)) {
				logger.info("Destoying resource " + endpoint + " " + key);
				try {
					EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(endpoint + FACTORY));
					ForwardIndexNodeFactoryPortType fpt = new ForwardIndexNodeFactoryServiceAddressingLocator()
							.getForwardIndexNodeFactoryPortTypePort(factoryEPR);
					fpt = GCUBERemotePortTypeContext.getProxy(fpt, scope);

					org.gcube.index.forwardindexnode.stubs.CreateResource cr = new org.gcube.index.forwardindexnode.stubs.CreateResource();
					cr.setIndexID(key);
					CreateResourceResponse crr = fpt.createResource(cr);
					logger.info("created resource at endpoint " + crr.getEndpointReference());
					ForwardIndexNodePortType pt = new ForwardIndexNodeServiceAddressingLocator().getForwardIndexNodePortTypePort(crr.getEndpointReference());
					pt = GCUBERemotePortTypeContext.getProxy(pt, scope, TIMEOUT);
					
					if (pt.shutdown("") == false) { //will not do delete
						logger.error("error deleting index at : " + endpoint);
						hasFailed = true;
					} else {
						logger.info("Destroying of discovered resource...");
						pt.destroy(new Destroy());
						logger.info("Destroying of discovered resource...OK");
					}
				} catch (MalformedURIException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (ServiceException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (RemoteException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (Exception e) {
					logger.error("Exception", e);
					hasFailed = true;
				}
			}
		}
		
		//Delete this resource
		
		
		return !(hasFailed);
	}

	public boolean refresh(VOID voidType) {
		initializeClusterID();
		try {
//			getForwardNode().invalidateCache();
//			getForwardNode().refreshIndexTypesOfIndex();
			getForwardNode().loadMetaFromDatabase();
		} catch (Exception e) {
			logger.error("Exception ", e);
			return false;
		}
		return true;
	}

	public boolean rebuildMetaIndex(VOID voidType) {
		initializeClusterID();
		try {
			Resource managementResource = getResource();

			if (managementResource.isInitializing())
				throw new Exception("Resource is not initialized yet");

			String[] collectionIds = managementResource.getCollectionID();
			String[] fields = managementResource.getFields();

			logger.info("Adding collectionsIDs: " + Arrays.toString(collectionIds));
			logger.info("Adding fields: " + Arrays.toString(fields));
			getForwardNode().loadMetaFromDatabase();

		} catch (Exception e) {
			logger.error("Exception", e);
			return false;
		}
		return true;
	}

	public boolean setCollections(StringArray collectionIDs) throws GCUBEFault {
		try {
			Resource resource = getResource();
			resource.setCollectionID(collectionIDs.getArray());
			resource.store();
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;
	}

	
	public boolean setFields(StringArray fields) throws GCUBEFault {
		try {
			Resource resource = getResource();
			resource.setFields(fields.getArray());
			resource.store();
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;
	}
	
	public boolean addKeyDescription(KeyDescriptionArray kda) throws GCUBEFault {
		try {
			Resource resource = getResource();
			KeyDescriptionType[] kdaOld = resource.getKeyDescription();
			
			Map<String, String> keyValues = new HashMap<String, String>();
		    logger.info("clusterID was null");
		    
		    if (kda != null && kda.getArray()!=null)
		    	for (KeyDescriptionType kdt : kda.getArray())
		    		keyValues.put(kdt.getKeyName(), kdt.getIndexTypeID());
			
		    logger.info("about to add index types");
		    
		    getForwardNode().addIndexTypes(keyValues);
 		    
		    KeyDescriptionType[] allKda = new KeyDescriptionType[kda.getArray().length + kdaOld.length];
	
		    resource.setKeyDescription(allKda);
			resource.store();		
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;		
	}
	
	public boolean setKeyDescription(KeyDescriptionArray kda) throws GCUBEFault {
		try {
			Map<String, String> keyValues = new HashMap<String, String>();
		    logger.info("clusterID was null");
		    
		    if (kda != null && kda.getArray()!=null)
		    	for (KeyDescriptionType kdt : kda.getArray())
		    		keyValues.put(kdt.getKeyName(), kdt.getIndexTypeID());
			
		    logger.info("about to add index types");
		    
		    getForwardNode().addIndexTypes(keyValues);
			
			Resource resource = getResource();
			resource.setKeyDescription(kda.getArray());
			resource.store();
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;
	}

	private boolean updateManagerProperties(final CouchBaseNode forwardNode) throws GCUBEFault {
		initializeClusterID();
		forwardNode.loadMetaFromDatabase();
		
		MetaIndex meta = forwardNode.getMetaIndex();

		ArrayList<String> collectionIdsToBeAdded = new ArrayList<String>(meta.getCollections());
		ArrayList<String> fieldsToBeAdded  = new ArrayList<String>(meta.getFields());

//		Map<String, String> keys = new HashMap<String, String>(meta.getIndexKeys());
//		KeyDescriptionType[] keyDescription = new KeyDescriptionType[keys.size()];
//		
//		int i = 0;
//		for (Map.Entry<String, String> e : keys.entrySet()) {
//			keyDescription[i] = new KeyDescriptionType();
//			keyDescription[i].setIndexTypeID(e.getKey());
//			keyDescription[i].setIndexTypeID(e.getValue());
//			i++;
//		}
		
		logger.info("fields to be added: " + fieldsToBeAdded);
		logger.info("Collections to be added: " + collectionIdsToBeAdded);

		HashMap<String, Set<String>> endpoints = discoverFulltextIndexNodes(Arrays.asList(forwardNode.getScope()), clusterID);

		StringArray sac = new StringArray();
		sac.setArray(Arrays.copyOf(collectionIdsToBeAdded.toArray(), collectionIdsToBeAdded.toArray().length, String[].class));
		StringArray saf = new StringArray();
		saf.setArray(Arrays.copyOf(fieldsToBeAdded.toArray(), fieldsToBeAdded.toArray().length, String[].class));

		for (String endpoint : endpoints.keySet()) {
			for (String key : endpoints.get(endpoint)) {
				logger.info("Recreating resource " + endpoint + " " + key);
				try {
					EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(endpoint + FACTORY));
					ForwardIndexNodeFactoryPortType fpt = new ForwardIndexNodeFactoryServiceAddressingLocator()
							.getForwardIndexNodeFactoryPortTypePort(factoryEPR);
					String scope = forwardNode.getScope();
					fpt = GCUBERemotePortTypeContext.getProxy(fpt, GCUBEScope.getScope(scope));

					org.gcube.index.forwardindexnode.stubs.CreateResource cr = new org.gcube.index.forwardindexnode.stubs.CreateResource();
					cr.setIndexID(key);
					CreateResourceResponse crr = fpt.createResource(cr);
					logger.info("created resource at endpoint " + crr.getEndpointReference());
					ForwardIndexNodePortType pt = new ForwardIndexNodeServiceAddressingLocator().getForwardIndexNodePortTypePort(crr.getEndpointReference());
					pt = GCUBERemotePortTypeContext.getProxy(pt, GCUBEScope.getScope(forwardNode.getScope()), TIMEOUT);
					pt.setCollections(sac);
					pt.setFields(saf);
					
//					KeyDescriptionArray kda = new KeyDescriptionArray();
//					kda.setArray(keyDescription);
//					pt.setKeyDescription(kda);
					
					logger.info("refreshing cache in " + crr.getEndpointReference());
					pt.refresh(new VOID());
				} catch (MalformedURIException e) {
					logger.error("Exception", e);
				} catch (ServiceException e) {
					logger.error("Exception", e);
				} catch (RemoteException e) {
					logger.error("Exception", e);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
			}

		}

		return true;
	}

	public static HashMap<String, Set<String>> discover(String serviceName, String serviceClass, List<String> scopes, String clusterID) {
		logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " clusterID : " + clusterID);
		
		HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();

		for (String scope : scopes) {
			ScopeProvider.instance.set(scope);

			SimpleQuery query = queryFor(ServiceInstance.class);
			query.addNamespace("ns1",URI.create("http://gcube-system.org/namespaces/index/ForwardIndexNode/service"))
				.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass +"'")
				.addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'")
				.addCondition("$resource/Data/ns1:ClusterID/text() eq '" + clusterID + "'");

			DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
			List<ServiceInstance> resources = client.submit(query);

			for (ServiceInstance se : resources) {
				
				logger.info("service instance properties : " + se.properties());
				
				
				
				String endpoint = se.endpoint().toString();
				if (endpoints.containsKey(endpoint)) {
					Set<String> wsr = endpoints.get(endpoint);
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				} else {
					Set<String> wsr = new HashSet<String>();
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				}

			}
		}
		return endpoints;
	}
	
	public static HashMap<String, Set<String>> discoverByIndexID(String serviceName, String serviceClass, List<String> scopes, String indexID, String epr) {
		logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " indexID : " + indexID);

		HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();

		for (String scope : scopes) {
			ScopeProvider.instance.set(scope);

			SimpleQuery query = queryFor(ServiceInstance.class);
			query.addNamespace("ns1", URI.create("http://gcube-system.org/namespaces/index/ForwardIndexNode/service"))
					.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'")
					.addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'")
					.addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'")
					.addCondition("$resource/Source/text() eq '" + epr + "'");

			DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
			List<ServiceInstance> resources = client.submit(query);

			for (ServiceInstance se : resources) {
				String endpoint = se.endpoint().toString();
				if (endpoints.containsKey(endpoint)) {
					Set<String> wsr = endpoints.get(endpoint);
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				} else {
					Set<String> wsr = new HashSet<String>();
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				}

			}
		}
		return endpoints;
	}
	

	public static HashMap<String, Set<String>> discoverFulltextIndexNodes(List<String> scopes, String clusterID) {
		return discover(SERVICE_NAME, SERVICE_CLASS, scopes, clusterID);
	}

	private Resource getResource() throws ResourceException {
		return (Resource) StatefulContext.getContext().getWSHome().find();
	}
	
	private String getResouceKey() {
		try {
			String resourceKey = this.getResource().getResourceKey();
			
			//String resourceKey = (String) getResource().getResourcePropertySet().get(Resource.RP_INDEX_ID).get(0);
			logger.info("getResouceKey : " + resourceKey);
			return resourceKey;
		} catch (Exception e) {
			logger.error("Exception", e);
			return null;
		}
	}
	
	private CouchBaseNode getForwardNode() {
		try {
			return getResource().getForwardNodeClient().getForwardNode();
		} catch (Exception e) {
			logger.error("Exception", e);
			return null;
		}
	}
	
	private String getForwardNodeClientScope() {
		try {
			return getResource().getForwardNodeClient().getScope();
		} catch (Exception e) {
			logger.error("Exception", e);
			return null;
		}
	}
	
	public static void main(String[] args) {
		discoverFulltextIndexNodes(Arrays.asList("/gcube/devsec"), "/gcube/devsec");
	}

}