/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.forwardindexnode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.index.forwardindexnode.ForwardIndexNode;
import org.gcube.index.forwardindexnode.Resource;
import org.gcube.index.forwardindexnode.ServiceContext;
import org.gcube.index.forwardindexnode.StatefulContext;
import org.gcube.index.forwardindexnode.stubs.CreateResource;
import org.gcube.index.forwardindexnode.stubs.CreateResourceResponse;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionArray;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardIndexNodeFactory
extends GCUBEPortType {
    private static final Logger logger = LoggerFactory.getLogger(ForwardIndexNodeFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static final int PERIOD = 2000;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        logger.info("In create resource!!!");
        String indexID = request.getIndexID();
        logger.info(" indexID : " + indexID);
        Object[] collectionIDs = request.getCollectionID();
        logger.info(" collectionIDs : " + Arrays.toString(collectionIDs));
        KeyDescriptionArray keyDescriptionArray = request.getKeyDescription();
        String contentType = "" + request.getContentType();
        logger.info("KeyDescriptionArray is null : " + (keyDescriptionArray == null ? "yes" : "no"));
        logger.info(" contentType : " + contentType);
        KeyDescriptionType[] keyDescription = keyDescriptionArray != null ? keyDescriptionArray.getArray() : null;
        logger.info("keyDescription : " + keyDescription);
        logger.info(" >>>  ForwardIndexManagementFactoryService::Create Resource  IndexID " + indexID + " " + contentType + " " + "KeyDescription: ");
        if (keyDescription != null) {
            for (int i = 0; i < keyDescription.length; ++i) {
                logger.info(" type-" + keyDescription[i].getIndexTypeID() + " name-" + keyDescription[i].getKeyName());
            }
        }
        String indexFormat = "MultiKeys";
        String clusterID = request.getClusterID();
        logger.info("clusterID : " + clusterID);
        CreateResourceResponse response = new CreateResourceResponse();
        logger.info("response : " + response);
        try {
            GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getContext();
            logger.info("ptcxt : " + ptcxt);
            GCUBEWSHome home = ptcxt.getWSHome();
            logger.info("home : " + home);
            GCUBEWSResourceKey key = ptcxt.makeKey(indexID == null ? uuidGen.nextUUID() : indexID);
            logger.info("key : " + key);
            logger.info("Created key:" + key.getValue().toString() + " " + indexID);
            GCUBEWSResource resource = home.create(key, new Object[]{key, indexID, collectionIDs, keyDescription, indexFormat, contentType, clusterID});
            response.setEndpointReference(resource.getEPR());
            response.setIndexID(((Resource)resource).getIndexID());
            resource.store();
            StatefulContext pctx = (StatefulContext)StatefulContext.getContext();
            HashMap<String, Set<String>> endpoints = null;
            String epr = resource.getEPR().getAddress().toString();
            while (endpoints == null || endpoints.size() != 1) {
                endpoints = ForwardIndexNode.discoverByIndexID("ForwardIndexNode", "Index", Arrays.asList(pctx.getServiceContext().getScope().toString()), key.getValue().toString(), epr);
                logger.info("Endpoints size: " + endpoints.size());
                if (endpoints.size() >= 1) continue;
                Thread.sleep(2000L);
            }
            return response;
        }
        catch (Exception e) {
            logger.error("unable to create resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }
}

