package org.gcube.fulltextindexnode.client.library.stubs;

import static org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants.*;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.fulltextindexnode.client.library.beans.Types;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface FullTextIndexNodeStub {

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocator(String feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String query(String query);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean shutdown(String shutdown);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean destroyNode(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean refresh(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean rebuildMetaIndex(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Types.GetIndexInformationResponse getIndexInformation();
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setCollections(Types.SetCollections collections);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setFields(Types.SetFields fields);
	
}
