package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.Arrays;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.fulltextindexnode.client.library.beans.Types.Destroy;
import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.QueryLimited;
import org.gcube.fulltextindexnode.client.library.beans.Types.StringArray;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;
import org.gcube.common.clients.Call;

public class FullTextIndexNodeCLDefaultProxy implements FullTextIndexNodeCLProxyI {

	private final ProxyDelegate<FullTextIndexNodeStub> delegate;

	public FullTextIndexNodeCLDefaultProxy(ProxyDelegate<FullTextIndexNodeStub> config) {
		this.delegate = config;
	}

	@Override
	public Boolean feedLocator(final String feedLocator) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.feedLocator(feedLocator);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public String query(final String query) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			@Override
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			@Override
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				QueryLimited queryLimited = new QueryLimited();
				queryLimited.query = query;
				queryLimited.count = count;
				queryLimited.from = from;
				
				return endpoint.queryLimited(queryLimited);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.shutdown(shutdown);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteCollection(collectionID);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean destroyNode() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.destroyNode(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean refresh() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.refresh(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean rebuildMetaIndex() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.rebuildMetaIndex(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, GetIndexInformationResponse> call = new Call<FullTextIndexNodeStub, GetIndexInformationResponse>() {

			@Override
			public GetIndexInformationResponse call(FullTextIndexNodeStub endpoint) throws Exception {

				return endpoint.getIndexInformation(new Empty());
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(collections);
				return endpoint.setCollections(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean setFields(final String[] fields) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			@Override
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(fields);
				return endpoint.setFields(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public void destroy() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Empty> call = new Call<FullTextIndexNodeStub, Empty>() {
			@Override
			public Empty call(FullTextIndexNodeStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	

}
