package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;


import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.fulltextindexnode.client.library.beans.Types.Destroy;
import org.gcube.fulltextindexnode.client.library.beans.Types.FeedLocator;
import org.gcube.fulltextindexnode.client.library.beans.Types.FeedLocatorUnit;
import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.QueryLimited;
import org.gcube.fulltextindexnode.client.library.beans.Types.Query;
import org.gcube.fulltextindexnode.client.library.beans.Types.StringArray;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;
import javax.xml.ws.BindingProvider;


public class FullTextIndexNodeCLDefaultProxy implements FullTextIndexNodeCLProxyI {

	private static long requestTimeout = 2 * 60 * 60 * 1000;
	
	private final ProxyDelegate<FullTextIndexNodeStub> delegate;

	public FullTextIndexNodeCLDefaultProxy(ProxyDelegate<FullTextIndexNodeStub> config) {
		this.delegate = config;
	}

	@Override
	public Boolean feedLocator(final String feedLocator) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocator feedLocatorRequest = new FeedLocator();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = null;
				feedLocatorRequest.activate = true;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = new ArrayList<String>();
				
				return endpoint.feedLocator(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocator(final String feedLocator, final String indexName, final Set<String> sids, final Boolean activate) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocator feedLocatorRequest = new FeedLocator();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = activate;
				feedLocatorRequest.sids = new StringArray();
				if (sids != null)
					feedLocatorRequest.sids.array = new ArrayList<String>(sids);
				
				if (feedLocatorRequest.activate == null)
					feedLocatorRequest.activate = false;
				
				return endpoint.feedLocator(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocator(final String feedLocator, final String indexName) throws FullTextIndexNodeException {
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocator feedLocatorRequest = new FeedLocator();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = true;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = new ArrayList<String>();
				
				return endpoint.feedLocator(feedLocatorRequest);
			}
		};
		try {
			
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocator(final String feedLocator, final String indexName, final Boolean activate) throws FullTextIndexNodeException {
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocator feedLocatorRequest = new FeedLocator();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = activate;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = null;
				
				if (feedLocatorRequest.activate == null)
					feedLocatorRequest.activate = false;
				
				return endpoint.feedLocator(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	
	///Feed Locator Unit
	@Override
	public Boolean feedLocatorUnit(final String feedLocator) throws FullTextIndexNodeException {
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocatorUnit feedLocatorRequest = new FeedLocatorUnit();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = null;
				feedLocatorRequest.activate = true;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = null;
				
				Map<String, Object> requestContext = ((BindingProvider)endpoint).getRequestContext();
				
				requestContext.put("javax.xml.ws.client.connectionTimeout ", requestTimeout); 
				requestContext.put("javax.xml.ws.client.receive", requestTimeout);
				requestContext.put("com.sun.xml.ws.connect.timeout", requestTimeout); 
				requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
				
				return endpoint.feedLocatorUnit(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocatorUnit(final String feedLocator, final String indexName, final Set<String> sids, final Boolean activate) throws FullTextIndexNodeException {
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocatorUnit feedLocatorRequest = new FeedLocatorUnit();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = activate;
				feedLocatorRequest.sids = new StringArray();
				if (sids != null)
					feedLocatorRequest.sids.array = new ArrayList<String>(sids);
				
				if (feedLocatorRequest.activate == null)
					feedLocatorRequest.activate = false;
				
				Map<String, Object> requestContext = ((BindingProvider)endpoint).getRequestContext();
				
				requestContext.put("javax.xml.ws.client.connectionTimeout ", requestTimeout); 
				requestContext.put("javax.xml.ws.client.receive", requestTimeout);
				requestContext.put("com.sun.xml.ws.connect.timeout", requestTimeout); 
				requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
				
				return endpoint.feedLocatorUnit(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocatorUnit(final String feedLocator, final String indexName) throws FullTextIndexNodeException {
		
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocatorUnit feedLocatorRequest = new FeedLocatorUnit();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = true;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = null;
				
				Map<String, Object> requestContext = ((BindingProvider)endpoint).getRequestContext();
				
				requestContext.put("javax.xml.ws.client.connectionTimeout ", requestTimeout); 
				requestContext.put("javax.xml.ws.client.receive", requestTimeout);
				requestContext.put("com.sun.xml.ws.connect.timeout", requestTimeout); 
				requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
				
				return endpoint.feedLocatorUnit(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean feedLocatorUnit(final String feedLocator, final String indexName, final Boolean activate) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				final FeedLocatorUnit feedLocatorRequest = new FeedLocatorUnit();
				feedLocatorRequest.resultSetLocation = feedLocator;
				feedLocatorRequest.indexName = indexName;
				feedLocatorRequest.activate = activate;
				feedLocatorRequest.sids = new StringArray();
				feedLocatorRequest.sids.array = null;
				
				if (feedLocatorRequest.activate == null)
					feedLocatorRequest.activate = false;
				
				Map<String, Object> requestContext = ((BindingProvider)endpoint).getRequestContext();
				
				requestContext.put("javax.xml.ws.client.connectionTimeout ", requestTimeout); 
				requestContext.put("javax.xml.ws.client.receive", requestTimeout);
				requestContext.put("com.sun.xml.ws.connect.timeout", requestTimeout); 
				requestContext.put("com.sun.xml.ws.request.timeout", requestTimeout);
				
				return endpoint.feedLocatorUnit(feedLocatorRequest);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	//Feed Locator Unit end
	
	
	
	
	
	
	
	
	
	
	@Override
	public Long collectionCount(final String collectionID) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Long> call = new Call<FullTextIndexNodeStub, Long>() {
			public Long call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.collectionCount(collectionID);
			}
		};
		try {
			Long response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean activateIndex(final String indexName) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.activateIndex(indexName);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public Boolean deleteIndex(final String indexName) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteIndex(indexName);
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

//	public Boolean feedLocatorUnit(final String feedLocator) throws FullTextIndexNodeException {
//		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
//			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
//				return endpoint.feedLocatorUnit(feedLocator);
//			}
//		};
//		try {
//			Boolean response = delegate.make(call);
//			return response;
//		} catch (Exception e) {
//			throw new FullTextIndexNodeException(e);
//		}
//	}
	
	@Override
	public Boolean flush() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.flush(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);
			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public List<String> getCollectionsOfIndex(final String indexName)
			throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, StringArray> call = new Call<FullTextIndexNodeStub, StringArray>() {
			public StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.getCollectionsOfIndex(indexName);
			}
		};
		try {
			StringArray response = delegate.make(call);
			return response.array;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public List<String> getIndicesOfCollection(final String collectionID)
			throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, StringArray> call = new Call<FullTextIndexNodeStub, StringArray>() {
			public StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.getIndicesOfCollection(collectionID);
			}
		};
		try {
			StringArray response = delegate.make(call);
			return response.array;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public String query(final String queryString, final Set<String> sids) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				Query query = new Query();
				query.query = queryString;
				query.sids = new StringArray();
				query.sids.array = new ArrayList<String>(sids);
				
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public String query(final String queryString) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				Query query = new Query();
				query.query = queryString;
				query.sids = new StringArray();
				query.sids.array = new ArrayList<String>();
				
				return endpoint.query(query);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>() {
			public String call(FullTextIndexNodeStub endpoint) throws Exception {
				QueryLimited queryLimited = new QueryLimited();
				queryLimited.query = query;
				queryLimited.count = count;
				queryLimited.from = from;
				
				return endpoint.queryLimited(queryLimited);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.shutdown(shutdown);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
	
	@Override
	public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.deleteCollection(collectionID);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean destroyNode() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.destroyNode(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean refresh() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.refresh(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean rebuildMetaIndex() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {

			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
				return endpoint.rebuildMetaIndex(new Empty());
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, GetIndexInformationResponse> call = new Call<FullTextIndexNodeStub, GetIndexInformationResponse>() {

			public GetIndexInformationResponse call(FullTextIndexNodeStub endpoint) throws Exception {

				return endpoint.getIndexInformation(new Empty());
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(collections);
				return endpoint.setCollections(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public boolean setFields(final String[] fields) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>() {
			public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {

				StringArray request = new StringArray();
				request.array = Arrays.asList(fields);
				return endpoint.setFields(request);
			}
		};
		try {
			Boolean response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}

	@Override
	public void destroy() throws FullTextIndexNodeException {
		Call<FullTextIndexNodeStub, Empty> call = new Call<FullTextIndexNodeStub, Empty>() {
			public Empty call(FullTextIndexNodeStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}


}
