package org.gcube.fulltextindexnode.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeFactoryCLDefaultProxy;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeFactoryCLProxyI;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeFactoryStub;
import org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class FullTextIndexNodeFactoryCLPlugin implements Plugin<FullTextIndexNodeFactoryStub, FullTextIndexNodeFactoryCLProxyI> {

	
	public String name() {
		return FullTextIndexNodeCLConstants.FACTORYNAME;
	}

	
	public String namespace() {
		return FullTextIndexNodeCLConstants.NAMESPACE;
	}

	
	public String serviceClass() {
		return FullTextIndexNodeCLConstants.gcubeClass;
	}

	
	public String serviceName() {
		return FullTextIndexNodeCLConstants.gcubeName;
	}
	
	
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	
	public FullTextIndexNodeFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(FullTextIndexNodeCLConstants.ftinf).at(reference);
	}

	
	public FullTextIndexNodeFactoryCLProxyI newProxy(ProxyDelegate<FullTextIndexNodeFactoryStub> delegate) {
		return new FullTextIndexNodeFactoryCLDefaultProxy(delegate);
	}

}
