package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.List;
import java.util.Set;

import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;

public interface FullTextIndexNodeCLProxyI {
	
//	public Boolean feedLocator(final String feedLocator) throws FullTextIndexNodeException;
//	
//	public Boolean feedLocator(final String feedLocator, final String indexName) throws FullTextIndexNodeException;

	public Boolean feedLocator(final String feedLocator, final String indexName, final Set<String> sids, final Boolean activate) throws FullTextIndexNodeException;
	
	public Boolean activateIndex(final String indexName) throws FullTextIndexNodeException;
	
	public Boolean deleteIndex(final String indexName) throws FullTextIndexNodeException;
	
	public Boolean feedLocatorUnit(final String feedLocator) throws FullTextIndexNodeException;
	
	public Long collectionCount(final String collectionID) throws FullTextIndexNodeException;
	
	public Boolean flush() throws FullTextIndexNodeException;
	
	public String query(final String query) throws FullTextIndexNodeException;
	
	public List<String> getCollectionsOfIndex(final String indexName) throws FullTextIndexNodeException;
	
	public List<String> getIndicesOfCollection(final String collectionID) throws FullTextIndexNodeException;
	
	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException;
	
	public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException;

	public boolean destroyNode() throws FullTextIndexNodeException;

	public boolean refresh() throws FullTextIndexNodeException;
	
	public boolean rebuildMetaIndex() throws FullTextIndexNodeException;
	
	public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException;
	
	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException;
	
	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException;
	
	public boolean setFields(final String[] fields) throws FullTextIndexNodeException;
	
	public void destroy() throws FullTextIndexNodeException;

	
}
