/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.fulltextindexnode;

import elasticsearchindex.FullTextNode;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.index.fulltextindexnode.Resource;
import org.gcube.index.fulltextindexnode.ServiceContext;
import org.gcube.index.fulltextindexnode.StatefulContext;
import org.gcube.index.fulltextindexnode.stubs.CreateResource;
import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodeFactoryPortType;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodePortType;
import org.gcube.index.fulltextindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.fulltextindexnode.stubs.StringArray;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeServiceAddressingLocator;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextIndexNode
extends GCUBEPortType {
    protected static final String FACTORY = "Factory";
    protected static final String SERVICE_NAME = "FullTextIndexNode";
    protected static final String SERVICE_CLASS = "Index";
    private static final String USE_CLUSTER_ID = "useClusterId";
    protected static final int TIMEOUT = 700000;
    private static final Logger logger = LoggerFactory.getLogger(FullTextIndexNode.class);
    private String clusterID = null;

    protected void onReady() throws Exception {
        super.onReady();
    }

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public synchronized GetIndexInformationResponse getIndexInformation(VOID request) throws GCUBEFault {
        try {
            Resource managementResource = this.getResource();
            if (managementResource.isInitializing()) {
                throw new Exception("Resource is not initialized yet");
            }
            GetIndexInformationResponse response = new GetIndexInformationResponse();
            response.setIndexID(managementResource.getIndexID());
            StringArray colStringArray = new StringArray();
            colStringArray.setArray(managementResource.getCollectionID());
            response.setCollectionID(colStringArray);
            StringArray fieldStringArray = new StringArray();
            fieldStringArray.setArray(managementResource.getFields());
            response.setFields(fieldStringArray);
            return response;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw new GCUBEFault(new String[]{e.getMessage()});
        }
    }

    private void initializeClusterID() {
        StatefulContext pctx;
        boolean useClusterID;
        if (this.clusterID == null) {
            try {
                logger.info("clusterID was null");
                this.clusterID = (String)this.getResource().getResourcePropertySet().get("ClusterID").get(0);
                logger.info("after get resource clusterID is : " + this.clusterID);
            }
            catch (ResourceException e) {
                logger.error("Error while initializing cluster id", (Throwable)e);
            }
        }
        if (!(useClusterID = ((Boolean)(pctx = (StatefulContext)StatefulContext.getContext()).getProperty(USE_CLUSTER_ID, new boolean[0])).booleanValue())) {
            this.clusterID = ServiceContext.getContext().getScope().toString();
        }
    }

    public boolean feedLocator(String resultSetLocation) {
        this.initializeClusterID();
        final String fResultSetLocation = resultSetLocation;
        String key = this.getResouceKey();
        logger.info("resource key in feeding : " + key);
        final FullTextNode fulltextnode = this.getFullTextNode();
        new Thread(){

            @Override
            public void run() {
                try {
                    HashMap colForField = new HashMap();
                    boolean result = fulltextnode.feedLocator(fResultSetLocation, colForField);
                    logger.info("Feeding completed, result was: " + result);
                    if (result) {
                        FullTextIndexNode.this.updateManagerProperties(fulltextnode);
                    }
                    logger.info("Properties updating completed");
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public String query(String queryString) {
        this.initializeClusterID();
        try {
            return this.getFullTextNode().query(queryString);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return "Caught Exception " + e.getMessage();
        }
    }

    public boolean shutdown(String nothing) {
        this.initializeClusterID();
        try {
            if (nothing != null && nothing.trim().equalsIgnoreCase("DELETE")) {
                this.getFullTextNode().delete();
            }
            this.getFullTextNode().close();
            return true;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
    }

    public boolean destroyNode(VOID voidType) {
        this.initializeClusterID();
        boolean hasFailed = false;
        HashMap<String, Set<String>> endpoints = FullTextIndexNode.discoverFulltextIndexNodes(Arrays.asList(this.getFullTextNodeClientScope()), this.clusterID);
        logger.info("Found endpoints to shutdown " + endpoints);
        logger.info("Deleting indices...");
        this.getFullTextNode().delete();
        logger.info("Deleting indices DONE");
        for (String endpoint : endpoints.keySet()) {
            for (String key : endpoints.get(endpoint)) {
                logger.info("Destoying resource " + endpoint + " " + key);
                try {
                    EndpointReferenceType factoryEPR = new EndpointReferenceType((URI)new AttributedURI(endpoint + FACTORY));
                    FullTextIndexNodeFactoryPortType fpt = new FullTextIndexNodeFactoryServiceAddressingLocator().getFullTextIndexNodeFactoryPortTypePort(factoryEPR);
                    fpt = (FullTextIndexNodeFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)fpt, (GCUBEScope)GCUBEScope.getScope((String)this.getFullTextNodeClientScope()), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    CreateResource cr = new CreateResource();
                    cr.setIndexID(key);
                    CreateResourceResponse crr = fpt.createResource(cr);
                    logger.info("created resource at endpoint " + crr.getEndpointReference());
                    FullTextIndexNodePortType pt = new FullTextIndexNodeServiceAddressingLocator().getFullTextIndexNodePortTypePort(crr.getEndpointReference());
                    pt = (FullTextIndexNodePortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)this.getFullTextNodeClientScope()), (int)700000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    if (!pt.shutdown("")) {
                        logger.error("error deleting index at : " + endpoint);
                        hasFailed = true;
                        continue;
                    }
                    logger.info("Destroying of discovered resource...");
                    pt.destroy(new Destroy());
                    logger.info("Destroying of discovered resource...OK");
                }
                catch (URI.MalformedURIException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (ServiceException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (RemoteException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
            }
        }
        return !hasFailed;
    }

    public boolean refresh(VOID voidType) {
        this.initializeClusterID();
        try {
            this.getFullTextNode().invalidateCache();
            this.getFullTextNode().refreshIndexTypesOfIndex();
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean rebuildMetaIndex(VOID voidType) {
        this.initializeClusterID();
        try {
            Resource managementResource = this.getResource();
            if (managementResource.isInitializing()) {
                throw new Exception("Resource is not initialized yet");
            }
            Object[] collectionIds = managementResource.getCollectionID();
            Object[] fields = managementResource.getFields();
            logger.info("Adding collectionsIDs: " + Arrays.toString(collectionIds));
            logger.info("Adding fields: " + Arrays.toString(fields));
            this.getFullTextNode().rebuildMetaIndex((String[])collectionIds, (String[])fields);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setCollections(StringArray collectionIDs) throws GCUBEFault {
        try {
            Resource resource = this.getResource();
            resource.setCollectionID(collectionIDs.getArray());
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    public boolean setFields(StringArray fields) throws GCUBEFault {
        try {
            Resource resource = this.getResource();
            resource.setFields(fields.getArray());
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    private boolean updateManagerProperties(FullTextNode fulltextnode) throws GCUBEFault {
        this.initializeClusterID();
        Map result = null;
        try {
            SearchResponse response = (SearchResponse)fulltextnode.getIndexClient().prepareSearch(new String[]{FullTextNode.META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
            }
        }
        catch (Exception e) {
            logger.warn("Meta Index missing");
        }
        if (result == null) {
            throw new RuntimeException("no meta-index document found");
        }
        ArrayList collectionIdsToBeAdded = (ArrayList)result.get("collectionIDs");
        ArrayList fieldsToBeAdded = (ArrayList)result.get("fields");
        logger.info("fields to be added: " + fieldsToBeAdded);
        logger.info("Collections to be added: " + collectionIdsToBeAdded);
        HashMap<String, Set<String>> endpoints = FullTextIndexNode.discoverFulltextIndexNodes(Arrays.asList(fulltextnode.getScope()), this.clusterID);
        for (String endpoint : endpoints.keySet()) {
            for (String key : endpoints.get(endpoint)) {
                logger.info("Recreating resource " + endpoint + " " + key);
                try {
                    EndpointReferenceType factoryEPR = new EndpointReferenceType((URI)new AttributedURI(endpoint + FACTORY));
                    FullTextIndexNodeFactoryPortType fpt = new FullTextIndexNodeFactoryServiceAddressingLocator().getFullTextIndexNodeFactoryPortTypePort(factoryEPR);
                    String scope = fulltextnode.getScope();
                    fpt = (FullTextIndexNodeFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)fpt, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    CreateResource cr = new CreateResource();
                    cr.setIndexID(key);
                    CreateResourceResponse crr = fpt.createResource(cr);
                    logger.info("created resource at endpoint " + crr.getEndpointReference());
                    FullTextIndexNodePortType pt = new FullTextIndexNodeServiceAddressingLocator().getFullTextIndexNodePortTypePort(crr.getEndpointReference());
                    pt = (FullTextIndexNodePortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)fulltextnode.getScope()), (int)700000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    StringArray sac = new StringArray();
                    sac.setArray((String[])Arrays.copyOf(collectionIdsToBeAdded.toArray(), collectionIdsToBeAdded.toArray().length, String[].class));
                    pt.setCollections(sac);
                    StringArray saf = new StringArray();
                    saf.setArray((String[])Arrays.copyOf(fieldsToBeAdded.toArray(), fieldsToBeAdded.toArray().length, String[].class));
                    pt.setFields(saf);
                    logger.info("refreshing cache in " + crr.getEndpointReference());
                    pt.refresh(new VOID());
                }
                catch (URI.MalformedURIException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (ServiceException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (RemoteException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static HashMap<String, Set<String>> discover(String serviceName, String serviceClass, List<String> scopes, String clusterID) {
        logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " clusterID : " + clusterID);
        HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            query.addNamespace("ns1", java.net.URI.create("http://gcube-system.org/namespaces/index/FullTextIndexNode/service")).addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'").addCondition("$resource/Data/ns1:ClusterID/text() eq '" + clusterID + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            for (ServiceInstance se : resources) {
                Set<Object> wsr;
                String endpoint = se.endpoint().toString();
                if (endpoints.containsKey(endpoint)) {
                    wsr = endpoints.get(endpoint);
                    wsr.add(se.key());
                    endpoints.put(endpoint, wsr);
                    continue;
                }
                wsr = new HashSet();
                wsr.add(se.key());
                endpoints.put(endpoint, wsr);
            }
        }
        return endpoints;
    }

    public static HashMap<String, Set<String>> discoverFulltextIndexNodes(List<String> scopes, String clusterID) {
        return FullTextIndexNode.discover(SERVICE_NAME, SERVICE_CLASS, scopes, clusterID);
    }

    private Resource getResource() throws ResourceException {
        return (Resource)StatefulContext.getContext().getWSHome().find();
    }

    private String getResouceKey() {
        try {
            String resourceKey = this.getResource().getResourceKey();
            logger.info("getResouceKey : " + resourceKey);
            return resourceKey;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    private FullTextNode getFullTextNode() {
        try {
            return this.getResource().getFullTextNodeClient().getFullTextNode();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    private String getFullTextNodeClientScope() {
        try {
            return this.getResource().getFullTextNodeClient().getScope();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }
}

