package org.gcube.index.fulltextindexnode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import elasticsearchindex.FullTextNode;

public class FullTextNodeClient {
	private static Map<String, FullTextNodeClient> uniqInstanceMap = new HashMap<String, FullTextNodeClient>(); 

	private static final String MAXIMUM_FRAGMENT_CNT = "maxFragmentCnt";
	private static final String MAXIMUM_FRAGMENT_SIZE = "maxFragmentSize";
	private static final String NO_REPLICAS = "noReplicas";
	private static final String NO_SHARDS = "noShards";
	private static final String ELASTICSEARCH_PORT = "elasticSearchPort";
	private static final String USE_CLUSTER_ID = "useClusterId";
	private static final String DATA_DIRECTORY = "dataDir";
	
	//private static String scope;
	//private static String clusterName;
	//private static String dataDir;
	private FullTextNode ftn;
	
	private static final Logger logger = LoggerFactory.getLogger(FullTextNodeClient.class);
	
	public FullTextNodeClient(String clusterID) {
		try {
			StatefulContext pctx = (StatefulContext) StatefulContext.getContext();
			int fragm_cnt = (Integer) pctx.getProperty(MAXIMUM_FRAGMENT_CNT);
			int fragm_size = (Integer) pctx.getProperty(MAXIMUM_FRAGMENT_SIZE);
			int noReplicas = (Integer) pctx.getProperty(NO_REPLICAS);
			int noShards = (Integer) pctx.getProperty(NO_SHARDS);
			int esPort = (Integer) pctx.getProperty(ELASTICSEARCH_PORT);
			boolean useClusterID = (Boolean) pctx.getProperty(USE_CLUSTER_ID);
			String dataDirectory = (String) pctx.getProperty(DATA_DIRECTORY);
			
			logger.info("Data read from jndi");
			logger.info("fragm_cnt      : " + fragm_cnt);
			logger.info("fragm_size     : " + fragm_size);
			logger.info("noReplicas     : " + noReplicas);
			logger.info("noShards       : " + noShards);
			logger.info("esPort         : " + esPort);
			logger.info("useClusterID   : " + useClusterID);
			logger.info("dataDirectory  : " + dataDirectory);
			
			String dataDir = null;
			
			if (dataDirectory != null) {
				dataDir = dataDirectory;
			} else {
				dataDir = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/indexData/elasticsearch/";
			}
			
			
			String scope = ServiceContext.getContext().getScope().toString();
			logger.info("Setting index scope to "+scope);
			
			
			String clusterName = "elastic-search-cluster-service-";
			if (!useClusterID)
				clusterID = scope;
			
			clusterName += clusterID;
			
			
			ftn = new FullTextNode(dataDir, clusterName, "main-index", noReplicas, noShards, scope, fragm_cnt, fragm_size);
			
			HashMap<String, Set<String>> endpoints = FullTextIndexNode.discover(FullTextIndexNode.SERVICE_NAME, FullTextIndexNode.SERVICE_CLASS, Arrays.asList(scope), clusterID);
			Map<String, Integer> knownNodes = new HashMap<String, Integer>();
			for(String key : endpoints.keySet()) {
				knownNodes.put(extractDomain(key), esPort);
			}
			if(knownNodes.size()>0)
				ftn.joinCluster(knownNodes);
			else
				ftn.createOrJoinCluster();
			ftn.addMetaIndex();
			ftn.refreshIndexTypesOfIndex();
			
		} catch (Exception e) {
			logger.error("Caught Exception", e);
		}
	}

	public FullTextNode getFullTextNode()
	{
		return this.ftn;
	}
	
	public String getScope()
	{
		return this.ftn.getScope();
	}
	
	public String getClusterName()
	{
		return this.ftn.getClusterName();
	}
	
	private static String extractDomain(String endpoint)
	{
		endpoint = endpoint.substring(endpoint.indexOf("://")+3);
		endpoint = endpoint.substring(0, endpoint.indexOf(":"));
		return endpoint;
	}
	

}