/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.fulltextindexnode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.index.fulltextindexnode.FullTextIndexNode;
import org.gcube.index.fulltextindexnode.ServiceContext;
import org.gcube.index.fulltextindexnode.StatefulContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNodeClient {
    private static final String MAXIMUM_FRAGMENT_CNT = "maxFragmentCnt";
    private static final String MAXIMUM_FRAGMENT_SIZE = "maxFragmentSize";
    private static final String NO_REPLICAS = "noReplicas";
    private static final String NO_SHARDS = "noShards";
    private static final String ELASTICSEARCH_PORT = "elasticSearchPort";
    private static final String USE_CLUSTER_ID = "useClusterId";
    private static final String USE_RRADAPTOR = "useRRAdaptor";
    private static final String DATA_DIRECTORY = "dataDir";
    private static final String HIGHLIGHTED_FIELDS = "highlightedFields";
    private FullTextNode ftn;
    private static final Logger logger = LoggerFactory.getLogger(FullTextNodeClient.class);

    public FullTextNodeClient(String clusterID) {
        try {
            StatefulContext pctx = (StatefulContext)StatefulContext.getContext();
            int fragm_cnt = (Integer)pctx.getProperty(MAXIMUM_FRAGMENT_CNT, new boolean[0]);
            int fragm_size = (Integer)pctx.getProperty(MAXIMUM_FRAGMENT_SIZE, new boolean[0]);
            int noReplicas = (Integer)pctx.getProperty(NO_REPLICAS, new boolean[0]);
            int noShards = (Integer)pctx.getProperty(NO_SHARDS, new boolean[0]);
            int esPort = (Integer)pctx.getProperty(ELASTICSEARCH_PORT, new boolean[0]);
            boolean useClusterID = (Boolean)pctx.getProperty(USE_CLUSTER_ID, new boolean[0]);
            String dataDirectory = (String)pctx.getProperty(DATA_DIRECTORY, new boolean[0]);
            boolean useRRAdaptor = (Boolean)pctx.getProperty(USE_RRADAPTOR, new boolean[0]);
            String highlightedFieldsString = (String)pctx.getProperty(HIGHLIGHTED_FIELDS, new boolean[0]);
            logger.info("Data read from jndi");
            logger.info("fragm_cnt           : " + fragm_cnt);
            logger.info("fragm_size          : " + fragm_size);
            logger.info("noReplicas          : " + noReplicas);
            logger.info("noShards            : " + noShards);
            logger.info("esPort              : " + esPort);
            logger.info("useClusterID        : " + useClusterID);
            logger.info("dataDirectory       : " + dataDirectory);
            logger.info("useRRAdaptor        : " + useRRAdaptor);
            logger.info("highlightedFields   : " + highlightedFieldsString);
            String dataDir = null;
            dataDir = dataDirectory != null ? dataDirectory : ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/indexData/elasticsearch/";
            String scope = ServiceContext.getContext().getScope().toString();
            logger.info("Setting index scope to " + scope);
            String clusterName = "elastic-search-cluster-service-";
            if (!useClusterID) {
                clusterID = scope;
            }
            clusterName = clusterName + clusterID;
            this.ftn = !useRRAdaptor ? new FullTextNode(dataDir, clusterName, "main-index", Integer.valueOf(noReplicas), Integer.valueOf(noShards), scope, fragm_cnt, fragm_size, Boolean.valueOf(false)) : new FullTextNode(dataDir, clusterName, "main-index", Integer.valueOf(noReplicas), Integer.valueOf(noShards), scope, fragm_cnt, fragm_size);
            if (highlightedFieldsString != null) {
                String[] highlightedFieldsArr = highlightedFieldsString.split("\\s*,\\s*");
                if (highlightedFieldsArr == null || highlightedFieldsArr.length == 0) {
                    logger.info("couldnt extract highlighted fields from : " + highlightedFieldsString);
                } else {
                    List<String> highlightedFields = Arrays.asList(highlightedFieldsArr);
                    logger.info("highlighted fields list : " + highlightedFields);
                    this.ftn.setHighlightedFields(highlightedFields);
                }
            }
            HashMap<String, Set<String>> endpoints = FullTextIndexNode.discover("FullTextIndexNode", "Index", Arrays.asList(scope), clusterID);
            HashMap<String, Integer> knownNodes = new HashMap<String, Integer>();
            for (String key : endpoints.keySet()) {
                knownNodes.put(FullTextNodeClient.extractDomain(key), esPort);
            }
            if (knownNodes.size() > 0) {
                this.ftn.joinCluster(knownNodes);
            } else {
                this.ftn.createOrJoinCluster();
            }
            this.ftn.addMetaIndex();
            this.ftn.refreshIndexTypesOfIndex();
        }
        catch (Exception e) {
            logger.error("Caught Exception", (Throwable)e);
        }
    }

    public FullTextNode getFullTextNode() {
        return this.ftn;
    }

    public String getScope() {
        return this.ftn.getScope();
    }

    public String getClusterName() {
        return this.ftn.getClusterName();
    }

    private static String extractDomain(String endpoint) {
        endpoint = endpoint.substring(endpoint.indexOf("://") + 3);
        endpoint = endpoint.substring(0, endpoint.indexOf(":"));
        return endpoint;
    }
}

