package org.gcube.geoindexlookup.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.geoindexlookup.client.library.proxies.GeoIndexLookupCLDefaultProxy;
import org.gcube.geoindexlookup.client.library.proxies.GeoIndexLookupCLProxyI;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupStub;
import org.gcube.geoindexlookup.client.library.utils.GeoIndexLookupCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class GeoIndexLookupCLPlugin implements Plugin<GeoIndexLookupStub, GeoIndexLookupCLProxyI> {

	@Override
	public String name() {
		return GeoIndexLookupCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return GeoIndexLookupCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexLookupCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexLookupCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexLookupStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(GeoIndexLookupCLConstants.gil).at(reference);
		
	}
	
	@Override
	public GeoIndexLookupCLProxyI newProxy(ProxyDelegate<GeoIndexLookupStub> delegate) {
		return new GeoIndexLookupCLDefaultProxy(delegate);
	}

}
