package org.gcube.geoindexlookup.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.geoindexlookup.client.library.plugins.GeoIndexLookupCLPlugin;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupStub;
import org.gcube.geoindexlookup.client.library.utils.GeoIndexLookupCLConstants;

public class GeoIndexLookupDSL {
	
	public static final GeoIndexLookupCLPlugin gil_plugin = new GeoIndexLookupCLPlugin();
	
	
	public static StatefulQuery plugin(final String indexID) {
		
		StatefulQuery query = new StatefulQuery(gil_plugin);
		query.addNamespace("ns1",URI.create(GeoIndexLookupCLConstants.NAMESPACE))
		.addCondition("$resource/Data/ns1:IndexID/text() eq '"+indexID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(gil_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<GeoIndexLookupCLProxyI> getGeoIndexLookupProxyBuilder() {
		return new StatefulBuilderImpl<GeoIndexLookupStub,GeoIndexLookupCLProxyI>(gil_plugin);
	}
	
}
