package org.gcube.geoindexmanagement.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.geoindexmanagement.client.library.plugins.GeoIndexManagementCLPlugin;
import org.gcube.geoindexmanagement.client.library.stubs.GeoIndexManagementStub;
import org.gcube.geoindexmanagement.client.library.utils.GeoIndexManagementCLConstants;

public class GeoIndexManagementDSL {
	
	public static final GeoIndexManagementCLPlugin gim_plugin = new GeoIndexManagementCLPlugin();
	
	
	public static StatefulQuery plugin(final String indexID) {
		
		StatefulQuery query = new StatefulQuery(gim_plugin);
		query.addNamespace("ns1",URI.create(GeoIndexManagementCLConstants.NAMESPACE))
		.addCondition("$resource/Data/ns1:IndexID/text() eq '"+indexID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(gim_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<GeoIndexManagementCLProxyI> getGeoIndexManagementProxyBuilder() {
		return new StatefulBuilderImpl<GeoIndexManagementStub,GeoIndexManagementCLProxyI>(gim_plugin);
	}
	
}
