package org.gcube.geoindexmanagement.client.library.stubs;

import static org.gcube.geoindexmanagement.client.library.utils.GeoIndexManagementCLConstants.*;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.geoindexmanagement.client.library.beans.Types;
import org.gcube.geoindexmanagement.client.library.beans.Types.Destroy;
import org.gcube.geoindexmanagement.client.library.beans.Types.GetIndexInformationResponse;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface GeoIndexManagementStub {
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public String getIndexTypeName(final Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public Empty setIndexTypeName(final String indexTypeName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public Empty addCollectionID(final String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public Empty addFields(final Types.StringArray fields);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public GetIndexInformationResponse getIndexInformation(Empty empty);
	
	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);
	
}
