package org.gcube.geoindexmanagement.client.library.proxies;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.geoindexmanagement.client.library.beans.Types.Destroy;
import org.gcube.geoindexmanagement.client.library.beans.Types.StringArray;
import org.gcube.geoindexmanagement.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.geoindexmanagement.client.library.exceptions.GeoIndexManagementException;
import org.gcube.geoindexmanagement.client.library.stubs.GeoIndexManagementStub;
import org.gcube.common.clients.Call;

public class GeoIndexManagementCLDefaultProxy implements GeoIndexManagementCLProxyI {

	private final ProxyDelegate<GeoIndexManagementStub> delegate;

	public GeoIndexManagementCLDefaultProxy(ProxyDelegate<GeoIndexManagementStub> config) {
		this.delegate = config;
	}

	@Override
	public String getIndexTypeName() throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, String> call = new Call<GeoIndexManagementStub, String>() {
			@Override
			public String call(GeoIndexManagementStub endpoint) throws Exception {
				return endpoint.getIndexTypeName(new Empty());
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}

	@Override
	public void setIndexTypeName(final String indexTypeName) throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, Empty> call = new Call<GeoIndexManagementStub, Empty>() {
			@Override
			public Empty call(GeoIndexManagementStub endpoint) throws Exception {
				return endpoint.setIndexTypeName(indexTypeName);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}

	@Override
	public void addCollectionID(final String collectionID) throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, Empty> call = new Call<GeoIndexManagementStub, Empty>() {
			@Override
			public Empty call(GeoIndexManagementStub endpoint) throws Exception {
				return endpoint.addCollectionID(collectionID);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}

	@Override
	public void addFields(final StringArray fields) throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, Empty> call = new Call<GeoIndexManagementStub, Empty>() {
			@Override
			public Empty call(GeoIndexManagementStub endpoint) throws Exception {
				return endpoint.addFields(fields);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}

	@Override
	public GetIndexInformationResponse getIndexInformation() throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, GetIndexInformationResponse> call = new Call<GeoIndexManagementStub, GetIndexInformationResponse>() {
			@Override
			public GetIndexInformationResponse call(GeoIndexManagementStub endpoint) throws Exception {
				return endpoint.getIndexInformation(new Empty());
			}
		};
		try {
			GetIndexInformationResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}

	@Override
	public void destroy() throws GeoIndexManagementException {
		Call<GeoIndexManagementStub, Empty> call = new Call<GeoIndexManagementStub, Empty>() {
			@Override
			public Empty call(GeoIndexManagementStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}
	
}
