package org.gcube.geoindexmanagement.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.geoindexmanagement.client.library.beans.Types.CreateResource;
import org.gcube.geoindexmanagement.client.library.beans.Types.CreateResourceResponse;
import org.gcube.geoindexmanagement.client.library.exceptions.GeoIndexManagementException;
import org.gcube.geoindexmanagement.client.library.stubs.GeoIndexManagementFactoryStub;

public class GeoIndexManagementFactoryCLDefaultProxy implements GeoIndexManagementFactoryCLProxyI {

	private final ProxyDelegate<GeoIndexManagementFactoryStub> delegate;

	public GeoIndexManagementFactoryCLDefaultProxy(ProxyDelegate<GeoIndexManagementFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final CreateResource createResource) throws GeoIndexManagementException {
		Call<GeoIndexManagementFactoryStub, CreateResourceResponse> call = new Call<GeoIndexManagementFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(GeoIndexManagementFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexManagementException(e);
		}
	}
}
