/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.app;

import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.gcube.rest.index.service.IndexService;
import org.gcube.rest.index.service.inject.IndexServiceModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
public class IndexApp
extends Application {
    private Set<Class<?>> classes = new HashSet();
    private Set<Object> singletons = new HashSet();
    private static final Logger logger = LoggerFactory.getLogger(IndexApp.class);
    private static final String SCOPE_PARAM = "scope";
    private static final String RESOURCEFOLDERNAME_PARAM = "resourcesFoldername";

    public IndexApp(@Context ServletContext servletContext) throws Exception {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
        }
        catch (Exception e) {
            throw new Exception("could not load property file  : deploy.properties");
        }
        String scope = properties.getProperty(SCOPE_PARAM).trim();
        String resourcesFoldername = properties.getProperty(RESOURCEFOLDERNAME_PARAM).trim();
        logger.info("Initializing injector");
        Injector injector = Guice.createInjector((Module[])new Module[]{new IndexServiceModule(resourcesFoldername)});
        logger.info("Getting service instance from injector");
        IndexService service = (IndexService)injector.getInstance(IndexService.class);
        service.setScope(scope);
        logger.info("setting context attribute to register the service as managed");
        servletContext.setAttribute("resource-aware-managed-service", (Object)service);
        this.singletons.add(service);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

