/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.resources;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.rest.index.client.IndexClient;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.index.service.IndexClientWrapper;
import org.gcube.rest.index.service.IndexService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexResourceFactory
extends ResourceFactory<IndexResource> {
    private static final Logger logger = LoggerFactory.getLogger(IndexResourceFactory.class);
    private static final String DEFAULT_SAME_CLUSTER_PROP = "defaultSameCluster";
    private static final String SCOPE_PROP = "scope";
    private Map<String, IndexClientWrapper> indexClientWrappers = new ConcurrentHashMap();
    private Provider<IndexClientWrapper> ftnClientProvider;
    private final IndexDiscovererAPI<IndexResource> indexDiscoverer;
    private final Provider<IndexClient.Builder> clientProvider;

    @Inject
    public IndexResourceFactory(Provider<IndexClientWrapper> ftnClientProvider, IndexDiscovererAPI<IndexResource> indexDiscoverer, Provider<IndexClient.Builder> clientProvider) {
        this.ftnClientProvider = ftnClientProvider;
        this.indexDiscoverer = indexDiscoverer;
        this.clientProvider = clientProvider;
    }

    public FullTextNode getIndexNode(IndexResource resource) throws ResourceNotFoundException {
        if (!this.indexClientWrappers.containsKey(resource.getResourceID())) {
            throw new ResourceNotFoundException("resource with id : " + resource.getResourceID() + " not in map factory : " + this.indexClientWrappers.keySet());
        }
        return ((IndexClientWrapper)this.indexClientWrappers.get(resource.getResourceID())).getFullTextNode();
    }

    public IndexResource createResource(String resourceID, String params) throws StatefulResourceException {
        logger.info("IndexResource createResource");
        IndexResource resource = (IndexResource)new Gson().fromJson(params, IndexResource.class);
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        resource.setResourceID(resourceID);
        logger.info("IndexClientWrapper initializing");
        IndexClientWrapper clientWrapper = (IndexClientWrapper)this.ftnClientProvider.get();
        IndexResourceFactory.initICWToResource((IndexClientWrapper)clientWrapper, (IndexResource)resource, (String)this.getScope(), (IndexDiscovererAPI)this.indexDiscoverer, (Provider)this.clientProvider);
        this.indexClientWrappers.put(resourceID, clientWrapper);
        resource.setHostname(clientWrapper.getFullTextNode().getHostname());
        logger.info("hostname set to resource : " + resource.getHostname());
        return resource;
    }

    public void loadResource(IndexResource resource) throws StatefulResourceException {
        logger.info("IndexResource loadResource");
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        logger.info("IndexClientWrapper loading");
        IndexClientWrapper clientWrapper = (IndexClientWrapper)this.ftnClientProvider.get();
        IndexResourceFactory.loadICWToResource((IndexClientWrapper)clientWrapper, (IndexResource)resource, (String)this.getScope(), (IndexDiscovererAPI)this.indexDiscoverer, (Provider)this.clientProvider);
        resource.setHostname(clientWrapper.getFullTextNode().getHostname());
        logger.info("hostname set to resource : " + resource.getHostname());
        resource.onLoad();
        this.indexClientWrappers.put(resource.getResourceID(), clientWrapper);
    }

    public void closeResource(IndexResource resource) throws StatefulResourceException {
        IndexClientWrapper icw = (IndexClientWrapper)this.indexClientWrappers.get(resource.getResourceID());
        logger.info("Closing index...");
        icw.getFullTextNode().close();
        logger.info("Closing index...OK");
        this.indexClientWrappers.remove(resource.getResourceID());
    }

    public void destroyResource(IndexResource resource) throws StatefulResourceException {
        this.closeResource(resource);
    }

    private static void initICWToResource(IndexClientWrapper indexClientWrapper, IndexResource resource, String scope, IndexDiscovererAPI<IndexResource> indexDiscoverer, Provider<IndexClient.Builder> clientProvider) throws StatefulResourceException {
        if (resource.getIndexID() == null || resource.getIndexID().trim().length() == 0) {
            logger.info("No indexID given, assigning a new one: " + resource.getResourceID());
            resource.setIndexID(resource.getResourceID());
        }
        String transformedClusterName = IndexResourceFactory.transformClusterName((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope());
        resource.setClusterID(IndexResourceFactory.changeClusterID((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope()));
        try {
            logger.info("initializing FullTextNodeClient : ");
            indexClientWrapper.initialize(transformedClusterName, resource.getClusterID(), scope);
        }
        catch (Exception e) {
            throw new StatefulResourceException("error while initializing the fulltext index client", e);
        }
        String transportAddress = indexClientWrapper.getFullTextNode().getESTransportAddress();
        resource.setEsTransportAddress(transportAddress);
        List collectionsOfMetaIndex = null;
        List fieldsOfMetaIndex = null;
        try {
            collectionsOfMetaIndex = indexClientWrapper.getFullTextNode().getCollectionsFromMeta();
            fieldsOfMetaIndex = indexClientWrapper.getFullTextNode().getFieldsFromMeta();
        }
        catch (Exception e) {
            logger.warn("query to the meta index failed. Collection and fields will be considered null and will be updated be the next update", (Throwable)e);
        }
        if (collectionsOfMetaIndex != null && fieldsOfMetaIndex != null) {
            resource.setCollections(collectionsOfMetaIndex);
            resource.setFields(fieldsOfMetaIndex);
        } else {
            resource.setCollections(Collections.emptyList());
            resource.setFields(Collections.emptyList());
        }
        resource.setSupportedRelations(IndexResource.getSupportedRelationsSet());
    }

    private static void loadICWToResource(IndexClientWrapper indexClientWrapper, IndexResource resource, String scope, IndexDiscovererAPI<IndexResource> indexDiscoverer, Provider<IndexClient.Builder> clientProvider) throws StatefulResourceException {
        String transformedClusterName = IndexResourceFactory.transformClusterName((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope());
        resource.setClusterID(IndexResourceFactory.changeClusterID((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope()));
        try {
            logger.info("initializing FullTextNodeClient : ");
            indexClientWrapper.initialize(transformedClusterName, resource.getClusterID(), scope);
        }
        catch (Exception e) {
            throw new StatefulResourceException("error while initializing the fulltext index client", e);
        }
        String transportAddress = indexClientWrapper.getFullTextNode().getESTransportAddress();
        resource.setEsTransportAddress(transportAddress);
        logger.info("getting meta index values for existing index");
        List collectionsOfMetaIndex = null;
        List fieldsOfMetaIndex = null;
        try {
            collectionsOfMetaIndex = indexClientWrapper.getFullTextNode().getCollectionsFromMeta();
            fieldsOfMetaIndex = indexClientWrapper.getFullTextNode().getFieldsFromMeta();
        }
        catch (Exception e) {
            logger.warn("query to the meta index failed. Collection and fields will be considered null and will be updated be the next update", (Throwable)e);
        }
        if (collectionsOfMetaIndex != null && fieldsOfMetaIndex != null) {
            resource.setCollections(collectionsOfMetaIndex);
            resource.setFields(fieldsOfMetaIndex);
            try {
                IndexService.updateAllResourcesCollectionsAndFields((FullTextNode)indexClientWrapper.getFullTextNode(), (IndexClient.Builder)((IndexClient.Builder)clientProvider.get()), (String)resource.getClusterID(), indexDiscoverer, (String)scope);
            }
            catch (Exception e) {
                logger.warn("problem while updating all the available resources : ", (Throwable)e);
            }
        } else {
            resource.setCollections(Collections.emptyList());
            resource.setFields(Collections.emptyList());
        }
        resource.setSupportedRelations(IndexResource.getSupportedRelationsSet());
    }

    private static String transformClusterName(String initClusterID, String resourceID, String scope) {
        logger.info("calling transformedClusterName for parameters. initClusterID : " + initClusterID + ", resourceID : " + resourceID + ", scope : " + scope);
        String clusterName = IndexResourceFactory.changeClusterID((String)initClusterID, (String)resourceID, (String)scope);
        String ret = "es-cluster-" + scope + "-" + clusterName;
        ret = ret.replace("/", "-");
        logger.info("transformedClusterName : " + ret);
        return ret;
    }

    static String changeClusterID(String initClusterID, String resourceID, String scope) {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
        Boolean defaultSameCluster = Boolean.valueOf(properties.getProperty("defaultSameCluster"));
        String clusterName = null;
        clusterName = initClusterID != null ? initClusterID : (defaultSameCluster == true ? "default-cluster-name" : resourceID);
        return clusterName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScope() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty("scope");
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }
}

