/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.procedures;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.gcube.rest.index.common.entities.fields.config.FacetType;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.gcube.rest.index.service.accessors.IndexAccessor;
import org.gcube.rest.index.service.helpers.IndexMappingsEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InternalProcedures {
    private static final Logger logger = LoggerFactory.getLogger(InternalProcedures.class);
    private static final Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    private static boolean copyIndexDocuments(String fromIndex, String toIndex) {
        Client client = IndexAccessor.getFullTextNode().getIndexClient();
        SearchResponse scrollResp = (SearchResponse)client.prepareSearch(new String[]{fromIndex}).setScroll(new TimeValue(60000L)).setSize(100).get();
        long parsed = 0L;
        long indexed = 0L;
        long totalInIndex = scrollResp.getHits().getTotalHits();
        do {
            for (SearchHit hit : scrollResp.getHits().getHits()) {
                ++parsed;
                IndexResponse resp = IndexAccessor.getFullTextNode().addRecord(toIndex, hit.getId(), hit.getSourceAsString());
                if (resp.getId() == null || resp.getId().isEmpty()) continue;
                ++indexed;
            }
        } while ((scrollResp = (SearchResponse)client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet()).getHits().getHits().length != 0);
        return parsed == indexed && indexed == totalInIndex;
    }

    public static void waitForYellowOrGreenStatus() {
        InternalProcedures.waitForYellowOrGreenIndexStatus(null);
    }

    public static void waitForYellowOrGreenIndexStatus(String index) {
        ClusterHealthStatus health;
        Client client = IndexAccessor.getFullTextNode().getIndexClient();
        while ((health = index == null || index.isEmpty() ? ((ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet()).getStatus() : ((ClusterIndexHealth)((ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{index})).actionGet()).getIndices().get(index)).getStatus()) == ClusterHealthStatus.RED) {
        }
    }

    public static void hardReIndex(String indexNameToReIndex, Map<String, FacetType> fieldsTypesToSet) throws IOException {
        String tempIndexName = indexNameToReIndex + "-temp-reindexing";
        String indexTypeName = "gcube";
        Client client = IndexAccessor.getFullTextNode().getIndexClient();
        Settings previousSettings = (Settings)((GetSettingsResponse)client.admin().indices().getSettings(new GetSettingsRequest()).actionGet()).getIndexToSettings().get((Object)indexNameToReIndex);
        LinkedHashMap<String, Map> analyzers = new LinkedHashMap<String, Map>();
        analyzers.put("analyzer", IndexMappingsEditor.AnalyzerGenerator.formAnalysersFor((FacetType[])new FacetType[]{FacetType.NORMAL, FacetType.NON_TOKENIZED}));
        LinkedHashMap newerSettings = new LinkedHashMap();
        for (Map.Entry entry : previousSettings.getAsMap().entrySet()) {
            newerSettings.put(entry.getKey(), entry.getValue());
        }
        newerSettings.put("analysis", analyzers);
        MappingMetaData mapping = (MappingMetaData)((ImmutableOpenMap)((GetMappingsResponse)client.admin().indices().getMappings(new GetMappingsRequest()).actionGet()).getMappings().get((Object)indexNameToReIndex)).get((Object)indexTypeName);
        Map sourceAsMap = mapping.getSourceAsMap();
        for (Map.Entry<String, FacetType> entry : fieldsTypesToSet.entrySet()) {
            sourceAsMap = IndexMappingsEditor.subFieldIntoMappings((Map)mapping.getSourceAsMap(), (String)entry.getKey(), (FieldConfig)new FieldConfig(entry.getValue(), true, null, false, false));
        }
        client.admin().indices().prepareCreate(tempIndexName).setSettings(newerSettings).addMapping(indexTypeName, prettygson.toJson((Object)sourceAsMap)).execute().actionGet();
        InternalProcedures.waitForYellowOrGreenIndexStatus((String)tempIndexName);
        boolean status = InternalProcedures.copyIndexDocuments((String)indexNameToReIndex, (String)tempIndexName);
        LinkedHashMap sourceAsMapIMMUTABLE = new LinkedHashMap(sourceAsMap);
        LinkedHashMap newerSettingsIMMUTABLE = new LinkedHashMap(newerSettings);
        client.admin().indices().delete(new DeleteIndexRequest(indexNameToReIndex)).actionGet();
        InternalProcedures.waitForYellowOrGreenStatus();
        client.admin().indices().prepareCreate(indexNameToReIndex).setSettings(newerSettingsIMMUTABLE).addMapping(indexTypeName, prettygson.toJson(sourceAsMapIMMUTABLE)).execute().actionGet();
        InternalProcedures.waitForYellowOrGreenIndexStatus((String)indexNameToReIndex);
        status = InternalProcedures.copyIndexDocuments((String)tempIndexName, (String)indexNameToReIndex);
        client.admin().indices().delete(new DeleteIndexRequest(tempIndexName)).actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean softReIndex(String indexIDToReIndex, Map<String, FacetType> fieldsTypesToSet) throws IOException {
        boolean status;
        block12: {
            status = true;
            String indexTypeName = "gcube";
            HashSet allFacetTypes = Sets.newHashSet((Object[])FacetType.values());
            allFacetTypes.remove(FacetType.NONE);
            Client client = IndexAccessor.getFullTextNode().getIndexClient();
            Settings previousSettings2333333332 = (Settings)((GetSettingsResponse)client.admin().indices().getSettings(new GetSettingsRequest()).actionGet()).getIndexToSettings().get((Object)indexIDToReIndex);
            LinkedHashMap<String, Map> analyzers = new LinkedHashMap<String, Map>();
            analyzers.put("analyzer", IndexMappingsEditor.AnalyzerGenerator.formAnalysersFor((FacetType[])allFacetTypes.toArray(new FacetType[allFacetTypes.size()])));
            LinkedHashMap newerSettings = new LinkedHashMap();
            for (Map.Entry entry : previousSettings2333333332.getAsMap().entrySet()) {
                newerSettings.put(entry.getKey(), entry.getValue());
            }
            newerSettings.remove("index.number_of_shards");
            newerSettings.remove("index.number_of_replicas");
            newerSettings.put("analysis", analyzers);
            MappingMetaData mapping = (MappingMetaData)((ImmutableOpenMap)((GetMappingsResponse)client.admin().indices().getMappings(new GetMappingsRequest()).actionGet()).getMappings().get((Object)indexIDToReIndex)).get((Object)indexTypeName);
            Map sourceAsMap = mapping.getSourceAsMap();
            for (Map.Entry<String, FacetType> entry : fieldsTypesToSet.entrySet()) {
                sourceAsMap = IndexMappingsEditor.subFieldIntoMappings((Map)sourceAsMap, (String)entry.getKey(), (FieldConfig)new FieldConfig(entry.getValue(), true, null, false, false));
            }
            client.admin().indices().prepareClose(new String[]{indexIDToReIndex}).execute().actionGet();
            client.admin().indices().prepareUpdateSettings(new String[]{indexIDToReIndex}).setSettings(newerSettings).execute().actionGet();
            client.admin().indices().preparePutMapping(new String[]{indexIDToReIndex}).setType(indexTypeName).setSource(prettygson.toJson((Object)sourceAsMap)).execute().actionGet();
            client.admin().indices().prepareOpen(new String[]{indexIDToReIndex}).execute().actionGet();
            InternalProcedures.waitForYellowOrGreenIndexStatus((String)indexIDToReIndex);
            status = InternalProcedures.copyIndexDocuments((String)indexIDToReIndex, (String)indexIDToReIndex);
            try {
                client.admin().indices().prepareOpen(new String[]{indexIDToReIndex}).execute().actionGet();
            }
            catch (Exception previousSettings2333333332) {}
            break block12;
            catch (Exception ex) {
                try {
                    logger.debug("There was an exception during soft reindexing -> " + ex);
                    status = false;
                }
                catch (Throwable throwable) {
                    try {
                        client.admin().indices().prepareOpen(new String[]{indexIDToReIndex}).execute().actionGet();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    client.admin().indices().prepareOpen(new String[]{indexIDToReIndex}).execute().actionGet();
                }
                catch (Exception exception) {}
            }
        }
        return status;
    }
}

