package org.gcube.rest.index.service.ckan.beans;

import java.io.Serializable;
import java.util.Date;

import com.google.gson.Gson;

public class Resource implements Serializable{
	
	
	private static final long serialVersionUID = -2577606464557778119L;
	
	String package_id; //this is the item ID of which it belongs
	String name;
	String description;
	String url;

	String mimetype;
	String state;
	boolean datastore_active;	
	String created;
	String id;  //this is auto-generated
	String format;
	String resource_type;
	String resource_locator_function;
	String hash;
	
	
	public Resource(String itemID, String name, String description,	String url){
		this.package_id=itemID;
		this.name=name;
		this.description=description;
		this.url=url;
	}


	public String getId() {
		return id;
	}


	public String getName() {
		return name;
	}


	public String getDescription() {
		return description;
	}


	public String getUrl() {
		return url;
	}


	public String getMimetype() {
		return mimetype;
	}


	public String getState() {
		return state;
	}


	public boolean isDatastore_active() {
		return datastore_active;
	}


	public String getCreated() {
		return created;
	}


	public String getFormat() {
		return format;
	}


	public String getResource_type() {
		return resource_type;
	}


	public String getPackage_id() {
		return package_id;
	}


	public String getResource_locator_function() {
		return resource_locator_function;
	}


	public String getHash() {
		return hash;
	}


	public void setId(String id) {
		this.id = id;
	}


	public void setName(String name) {
		this.name = name;
	}


	public void setDescription(String description) {
		this.description = description;
	}


	public void setUrl(String url) {
		this.url = url;
	}


	public void setMimetype(String mimetype) {
		this.mimetype = mimetype;
	}


	public void setState(String state) {
		this.state = state;
	}


	public void setDatastore_active(boolean datastore_active) {
		this.datastore_active = datastore_active;
	}


	public void setCreated(String created) {
		this.created = created;
	}


	public void setFormat(String format) {
		this.format = format;
	}


	public void setResource_type(String resource_type) {
		this.resource_type = resource_type;
	}


	public void setPackage_id(String package_id) {
		this.package_id = package_id;
	}


	public void setResource_locator_function(String resource_locator_function) {
		this.resource_locator_function = resource_locator_function;
	}


	public void setHash(String hash) {
		this.hash = hash;
	}


	@Override
	public String toString() {
		return new Gson().toJson(this);
	}
	
	
	
	
	
}

/*
{
    "url_type": null,
    "created": "2017-10-10T16:13:29.881792",
    "format": "",
    "resource_type": null,
    "description": "",
    "package_id": "e1685255-b9c9-433d-b36b-2b23ef1c0869",
    "cache_last_updated": null,
    "resource_locator_protocol": "WWW:LINK-1.0-http--link",
    "url": "http:\/\/ecosystemdata.ices.dk\/Map\/index.aspx?Action=AddLayer&DataSet=663&LatN=&LatS=&LonE=&LonW=&Sdate=&Edate=",
    "resource_locator_function": "",
    "size": null,
    "cache_url": null,
    "datastore_active": false,
    "name": "Unnamed resource",
    "mimetype": null,
    "id": "516c185a-e63c-41d5-8a45-3b266616489a",
    "state": "active",
    "position": 0,
    "last_modified": null,
    "hash": "",
    "mimetype_inner": null,
    "revision_id": "666d8fae-e2b6-4dce-8b3c-b68edf31629c"
  }
*/