package org.gcube.indexmanagement.geo;

import java.util.Arrays;

import org.gcube.indexmanagement.geo.shape.Polygon;

/**
 * Container for the info needed for describing a 
 * refinement request
 * @author bill
 *
 */
public class RefinementRequest {
	
	private String refinerID;
	
	private String[] args;
	
	private boolean not = false;
	
	private InclusionType inclusion;
	
	private Polygon polygon;
	
	/**
	 * Default constructor
	 * 
	 * @param refinerID
	 * @param args
	 * @param not
	 */
	public RefinementRequest(Polygon polygon, String refinerID, String[] args, InclusionType inclusion, boolean not)
	{
		this.setPolygon(polygon);
		this.setRefinerID(refinerID);
		this.setArgs(args);
		this.not = not;
		this.setInclusion(inclusion);
	}

	/**
	 * setter for the refiner ID property
	 * @param refinerID
	 */
	public void setRefinerID(String refinerID) {
		this.refinerID = refinerID;
	}

	/**
	 * getter for the refiner ID property
	 * @return the refiner ID
	 */
	public String getRefinerID() {
		return refinerID;
	}

	/**
	 * setter for the arguments of the refiner
	 * @param args
	 */
	public void setArgs(String[] args) {
		this.args = args;
	}

	/**
	 * getter for the arguments of the refiner
	 * @return the arguments
	 */
	public String[] getArgs() {
		return args;
	}

	/**
	 * reverts the not property
	 * @param not
	 */
	public void revertNot() {
		this.not = !this.not;
	}

	/**
	 * getter for the not flag
	 * @return the not flag
	 */
	public boolean isNot() {
		return not;
	}

	/**
	 * setter for the inclusion property
	 * @param inclusion property
	 */
	public void setInclusion(InclusionType inclusion) {
		this.inclusion = inclusion;
	}

	/**
	 * getter for the inclusion property
	 * @return the inclusion property
	 */
	public InclusionType getInclusion() {
		return inclusion;
	}

	/**
	 * setter for the search-polygon property
	 * @param the search polygon
	 */
	public void setPolygon(Polygon polygon) {
		this.polygon = polygon;
	}

	/**
	 * getter for the search-polygon property
	 * @return the search polygon
	 */
	public Polygon getPolygon() {
		return polygon;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RefinerID: " + refinerID);
		builder.append(" - not: " + not);
		if(polygon != null) {
			builder.append(" - Polygon: " + polygon.toString());
		}
		if(inclusion != null) {
			builder.append(" - inclusion: " + inclusion);
		}
		builder.append(" - args: " + Arrays.toString(args));
		
		return builder.toString();
	}
}
