/**
 * FloatComparator.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: FloatComparator.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2007 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.jdbmwrapper;

/** 
 * This class compares two dates.
 * It compares its two arguments for order. Returns a negative integer, 
 * zero, or a positive integer as the first argument is less than, 
 * equal to, or greater than the second.
 */
public final class FloatComparator
    extends java.lang.Object
    implements java.util.Comparator,
               java.io.Serializable
{

    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal to, 
     * or greater than the second.
     * @param obj1 - The first date to compare
     * @param obj2 - The second date to compare
     * @return - a negative integer, zero, or a positive integer as the first
     *           argument is less than, equal to, or greater than the second.
     */
    public int compare(java.lang.Object obj1,
                       java.lang.Object obj2) {        
        Float f1 = (Float)(obj1);
        Float f2 = (Float)(obj2);
        //            System.out.println("The class of " + f1.compareTo(f2));
        return f1.compareTo(f2);
    }
}
