package org.gcube.indexmanagement.bdbwrapper;

import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.je.DatabaseEntry;

/** 
 * This class compares two Floats.
 * It compares its two arguments for order. Returns a negative integer, 
 * zero, or a positive integer as the first argument is less than, 
 * equal to, or greater than the second.
 */
public final class FloatComparator implements java.util.Comparator<byte[]>, java.io.Serializable
{

	public FloatComparator(){}
    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal to, 
     * or greater than the second.
     * @param obj1 - The first Float to compare
     * @param obj2 - The second Float to compare
     * @return - a negative integer, zero, or a positive integer as the first
     *           argument is less than, equal to, or greater than the second.
     */
    public int compare(byte[] obj1,
                       byte[] obj2) {
    	
    	DatabaseEntry entry1 = new DatabaseEntry();
        DatabaseEntry entry2 = new DatabaseEntry();
        entry1.setData(obj1);
        entry2.setData(obj2);
        Float s1 = FloatBinding.entryToFloat(entry1);
        Float s2 = FloatBinding.entryToFloat(entry2);
        return s1.compareTo(s2);
    }
}