package org.gcube.indexmanagement.common;

import javax.naming.Context;
import javax.naming.InitialContext;

import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * A utility class used to retrieve Index related MessageContext parameters *
 */
public class IndexContext {
	/** log4j logger */
	private static GCUBELog logger = new GCUBELog(IndexContext.class);

	/**
	 * A method used to get a resource object (from the JNDI file) for the current Index service if available.
	 * 
	 * @param resourceName - the name (with service path) of the resource to retrieve
	 * @return the requested configuration object
	 * @throws IndexException -
	 *             error getting the configuration object
	 */
	public static Object getJndiResourceObject(String resourceName) throws IndexException {
		try{
			Context initialContext = new InitialContext();
			return initialContext.lookup(org.globus.wsrf.Constants.JNDI_SERVICES_BASE_NAME + resourceName);
		} catch (Exception e) {
			logger.error("Exception while getting Jndi Resource Object.",e);
			throw new IndexException(e);
		}
	}
}
