/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.ranking.RankEvaluator;
import org.gcube.indexmanagement.geo.ranking.Sorter;
import org.gcube.indexmanagement.geo.refinement.Refiner;
import org.geotools.index.Data;

public class QueryResults {
    private int currentIdx;
    private int totHitCount;
    private int curRefCount;
    private int curUnrefCount;
    private int curRemovedCount;
    private ArrayList<DataWrapper> results;
    private ArrayList<DataWrapper> leftOvers;
    private Refiner[] refiners;
    private RankEvaluator ranker;
    private RandomAccessFile rawData;

    public QueryResults(GeoIndexType indexTypeObject, List<Data> unrefinedResults, Refiner[] refiners, RankEvaluator ranker, RandomAccessFile rawData) throws Exception {
        this.refiners = refiners;
        this.ranker = ranker;
        this.rawData = rawData;
        this.results = this.wrap(indexTypeObject, unrefinedResults);
        this.currentIdx = 0;
        this.totHitCount = unrefinedResults.size();
        this.curRefCount = 0;
        this.curUnrefCount = 0;
        this.curRemovedCount = 0;
        this.leftOvers = new ArrayList();
    }

    public synchronized ArrayList<DataWrapper> getNext(int numberOfResults) {
        ArrayList<DataWrapper> returnList = new ArrayList<DataWrapper>();
        if (this.leftOvers.size() > numberOfResults) {
            returnList.addAll(this.leftOvers.subList(0, numberOfResults));
            this.leftOvers = this.getSlice(this.leftOvers, numberOfResults, this.leftOvers.size());
            return returnList;
        }
        returnList.addAll(this.leftOvers);
        this.leftOvers.clear();
        while (returnList.size() < numberOfResults && this.currentIdx < this.results.size()) {
            int estEndIdx = Math.min(this.currentIdx + numberOfResults, this.results.size());
            if (this.ranker != null) {
                Sorter.partialQuickSort(this.results, this.currentIdx, estEndIdx, true, this.ranker);
            }
            if (this.refiners != null) {
                for (Refiner refiner : this.refiners) {
                    int removed = refiner.refine(this.results.subList(this.currentIdx, estEndIdx));
                    estEndIdx -= removed;
                    this.curRemovedCount += removed;
                }
            }
            returnList.addAll(this.results.subList(this.currentIdx, estEndIdx));
            this.currentIdx = estEndIdx;
        }
        this.curRefCount = this.currentIdx;
        this.curUnrefCount = this.currentIdx + this.curRemovedCount;
        if (returnList.size() > numberOfResults) {
            this.leftOvers = this.getSlice(returnList, numberOfResults, returnList.size());
            returnList = this.getSlice(returnList, 0, numberOfResults);
        }
        return returnList.isEmpty() ? null : returnList;
    }

    public synchronized ArrayList<DataWrapper> getRest() {
        return this.getNext(this.results.size() - this.currentIdx);
    }

    public synchronized ArrayList<DataWrapper> getAll() {
        if (this.currentIdx < this.results.size()) {
            if (this.ranker != null) {
                Sorter.partialQuickSort(this.results, this.currentIdx, this.results.size(), true, this.ranker);
            }
            if (this.refiners != null) {
                for (Refiner refiner : this.refiners) {
                    refiner.refine(this.results.subList(this.currentIdx, this.results.size()));
                }
            }
            this.leftOvers.addAll(this.results.subList(this.currentIdx, this.results.size()));
            this.currentIdx = this.results.size();
            this.curRefCount = this.results.size();
            this.curUnrefCount = this.totHitCount;
            this.curRemovedCount = this.curUnrefCount - this.curRefCount;
        }
        return this.results;
    }

    public synchronized int getTotalHitCount() {
        return this.totHitCount;
    }

    public synchronized int getCurrentRefinedCount() {
        return this.curRefCount;
    }

    public synchronized int getCurrentUnrefinedCount() {
        return this.curUnrefCount;
    }

    private <T> ArrayList<T> getSlice(List<T> list, int start, int end) {
        return new ArrayList<T>(list.subList(start, end));
    }

    private ArrayList<DataWrapper> wrap(GeoIndexType indexTypeObject, List<Data> list) throws Exception {
        ArrayList<DataWrapper> wrappedList = new ArrayList<DataWrapper>();
        for (Data data : list) {
            wrappedList.add(DataWrapper.getInstance(indexTypeObject, data, this.rawData));
        }
        return wrappedList;
    }
}

