/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.commons;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.common.ServiceContextContainer;

public class FeatureIndexStatsContainer
extends Thread {
    private static Logger log = Logger.getLogger(FeatureIndexStatsContainer.class);
    private Object lockMe = new Object();
    private String ServiceClass = null;
    private String ServiceName = null;
    private long NumberOfInvocations = 0L;
    private long NumberOfAdditions = 0L;
    private long MeanRecordsInAdditions = 0L;
    private long MeanAdditionTime = 0L;
    private long MaxAdditionTime = 0L;
    private long MinAdditionTime = Long.MAX_VALUE;
    private long NumberOfRemovals = 0L;
    private long RemovalTime = 0L;
    private long NumberOfLookups = 0L;
    private long MeanIndexLookupTime = 0L;
    private long MaxIndexLookupTime = 0L;
    private long MinIndexLookupTime = Long.MAX_VALUE;
    private long MeanLookupResults = 0L;
    private long MaxLookupResults = 0L;
    private long MinLookupResults = Long.MAX_VALUE;
    private ServiceContextContainer ServiceContextCont = null;

    public FeatureIndexStatsContainer(String ServiceClass, String ServiceName, ServiceContextContainer ServiceContextCont) {
        this.ServiceClass = ServiceClass;
        this.ServiceName = ServiceName;
        this.ServiceContextCont = ServiceContextCont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newInvocation() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfInvocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecords(long number) {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfAdditions;
            this.MeanRecordsInAdditions = (this.MeanRecordsInAdditions * (this.NumberOfAdditions - 1L) + number) / this.NumberOfAdditions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordsTime(long time) {
        Object object = this.lockMe;
        synchronized (object) {
            if (this.MinAdditionTime > time) {
                this.MinAdditionTime = time;
            }
            if (this.MaxAdditionTime < time) {
                this.MaxAdditionTime = time;
            }
            if (this.NumberOfAdditions != 0L) {
                this.MeanAdditionTime = (this.MeanAdditionTime * (this.NumberOfAdditions - 1L) + time) / this.NumberOfAdditions;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newRemoval() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfRemovals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removalTime(long time) {
        Object object = this.lockMe;
        synchronized (object) {
            this.RemovalTime += time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newIndexLookup() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfLookups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookupIndex(long time) {
        Object object = this.lockMe;
        synchronized (object) {
            if (this.MinIndexLookupTime > time) {
                this.MinIndexLookupTime = time;
            }
            if (this.MaxIndexLookupTime < time) {
                this.MaxIndexLookupTime = time;
            }
            if (this.NumberOfLookups != 0L) {
                this.MeanIndexLookupTime = (this.MeanIndexLookupTime * (this.NumberOfLookups - 1L) + time) / this.NumberOfLookups;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lookupResults(long results) {
        Object object = this.lockMe;
        synchronized (object) {
            if (this.MinLookupResults > results) {
                this.MinLookupResults = results;
            }
            if (this.MaxLookupResults < results) {
                this.MaxLookupResults = results;
            }
            if (this.NumberOfLookups != 0L) {
                this.MeanLookupResults = (this.MeanLookupResults * (this.NumberOfLookups - 1L) + results) / this.NumberOfLookups;
            }
        }
    }

    public void writeToRI() throws Exception {
        this.ServiceContextCont.getContext().getInstance().setSpecificData(this.toXML());
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1200000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.writeToRI();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"could not update RI profile.continuing", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Statistics>");
        buf.append("<text>");
        buf.append("this section summarizes some statisitc information for the service since the last restart");
        buf.append("</text>");
        buf.append("<NumberOfInvocations>");
        buf.append("<value>");
        buf.append(this.NumberOfInvocations);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of calls made to the service");
        buf.append("</description>");
        buf.append("</NumberOfInvocations>");
        buf.append("<NumberOfAdditions>");
        buf.append("<value>");
        buf.append(this.NumberOfAdditions);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of calls made for adding records to an index");
        buf.append("</description>");
        buf.append("</NumberOfAdditions>");
        buf.append("<MeanRecordsInAdditions>");
        buf.append("<value>");
        buf.append(this.MeanRecordsInAdditions);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean number of records in addition requests");
        buf.append("</description>");
        buf.append("</MeanRecordsInAdditions>");
        buf.append("<MeanAdditionTime>");
        buf.append("<value>");
        buf.append(this.MeanAdditionTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean time in addition requests");
        buf.append("</description>");
        buf.append("</MeanAdditionTime>");
        buf.append("<MaxAdditionTime>");
        buf.append("<value>");
        buf.append(this.MaxAdditionTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the max time in addition requests");
        buf.append("</description>");
        buf.append("</MaxAdditionTime>");
        buf.append("<MinAdditionTime>");
        buf.append("<value>");
        buf.append(this.MinAdditionTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the min time in addition requests");
        buf.append("</description>");
        buf.append("</MinAdditionTime>");
        buf.append("<NumberOfRemovals>");
        buf.append("<value>");
        buf.append(this.NumberOfRemovals);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the number of removal requests");
        buf.append("</description>");
        buf.append("</NumberOfRemovals>");
        buf.append("<RemovalTime>");
        buf.append("<value>");
        buf.append(this.RemovalTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the time for removal requests");
        buf.append("</description>");
        buf.append("</RemovalTime>");
        buf.append("<NumberOfLookups>");
        buf.append("<value>");
        buf.append(this.NumberOfLookups);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total lookup requests");
        buf.append("</description>");
        buf.append("</NumberOfLookups>");
        buf.append("<MeanIndexLookupTime>");
        buf.append("<value>");
        buf.append(this.MeanIndexLookupTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean time for a lookup");
        buf.append("</description>");
        buf.append("</MeanIndexLookupTime>");
        buf.append("<MeanLookupResults>");
        buf.append("<value>");
        buf.append(this.MeanLookupResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean results for a lookup");
        buf.append("</description>");
        buf.append("</MeanLookupResults>");
        buf.append("<MaxLookupResults>");
        buf.append("<value>");
        buf.append(this.MaxLookupResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the max results for a lookup");
        buf.append("</description>");
        buf.append("</MaxLookupResults>");
        buf.append("<MinLookupResults>");
        buf.append("<value>");
        buf.append(this.MinLookupResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the min results for a lookup");
        buf.append("</description>");
        buf.append("</MinLookupResults>");
        buf.append("</Statistics>");
        return buf.toString();
    }
}

