/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.commons;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;

public class DistanceCalculation {
    private static Logger log = Logger.getLogger(DistanceCalculation.class);

    public static float distance(float[] vector1, float[] vector2, float threshold, FIEnums.DistanceTypes distanceMeasure) throws Exception {
        if (distanceMeasure.compareTo(FIEnums.DistanceTypes.Eukledian) == 0) {
            return DistanceCalculation.distanceEukledian(vector1, vector2, threshold);
        }
        if (distanceMeasure.compareTo(FIEnums.DistanceTypes.Manhatan) == 0) {
            return DistanceCalculation.distanceManhattan(vector1, vector2, threshold);
        }
        log.error((Object)("Could not map enum to distance algo " + distanceMeasure.toString() + ". Throwing Exception"));
        throw new Exception("Could not map enum to distance algo " + distanceMeasure.toString());
    }

    public static float distance(float[] vector1, float[] vector2, float threshold, FIEnums.DistanceTypes distanceMeasure, float[] weights) throws Exception {
        if (distanceMeasure.compareTo(FIEnums.DistanceTypes.Eukledian) == 0) {
            return DistanceCalculation.distanceEukledian(vector1, vector2, threshold, weights);
        }
        if (distanceMeasure.compareTo(FIEnums.DistanceTypes.Manhatan) == 0) {
            return DistanceCalculation.distanceManhattan(vector1, vector2, threshold, weights);
        }
        log.error((Object)("Could not map enum to distance algo " + distanceMeasure.toString() + ". Throwing Exception"));
        throw new Exception("Could not map enum to distance algo " + distanceMeasure.toString());
    }

    private static float distanceEukledian(float[] vector1, float[] vector2, float threshold) {
        try {
            float ret = 0.0f;
            for (int i = 0; i < vector1.length; ++i) {
                float point = vector1[i] - vector2[i];
                if (!((ret += point * point) > threshold)) continue;
                return Float.MAX_VALUE;
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)("Could not compute Eukledian distance on vector with lengths " + vector1.length + " and " + vector2.length + " returning max value"));
            return Float.MAX_VALUE;
        }
    }

    private static float distanceEukledian(float[] vector1, float[] vector2, float threshold, float[] weights) {
        try {
            float ret = 0.0f;
            for (int i = 0; i < vector1.length; ++i) {
                float point = vector1[i] - vector2[i];
                if (!((ret += weights[i] * point * point) > threshold)) continue;
                return Float.MAX_VALUE;
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)("Could not compute Eukledian distance on vector with lengths " + vector1.length + " and " + vector2.length + " returning max value"));
            return Float.MAX_VALUE;
        }
    }

    private static float distanceManhattan(float[] vector1, float[] vector2, float threshold) {
        try {
            float ret = 0.0f;
            for (int i = 0; i < vector1.length; ++i) {
                float point = Math.abs(vector1[i] - vector2[i]);
                if (!((ret += point) > threshold)) continue;
                return Float.MAX_VALUE;
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)("Could not compute Manhattan distance on vector with lengths " + vector1.length + " and " + vector2.length + " returning max value"));
            return Float.MAX_VALUE;
        }
    }

    private static float distanceManhattan(float[] vector1, float[] vector2, float threshold, float[] weights) {
        try {
            float ret = 0.0f;
            for (int i = 0; i < vector1.length; ++i) {
                float point = Math.abs(vector1[i] - vector2[i]);
                if (!((ret += weights[i] * point) > threshold)) continue;
                return Float.MAX_VALUE;
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)("Could not compute Manhattan distance on vector with lengths " + vector1.length + " and " + vector2.length + " returning max value"));
            return Float.MAX_VALUE;
        }
    }
}

