package org.gcube.indexmanagement.bdbwrapper;

import org.gcube.common.core.utils.logging.GCUBELog;

/** 
 * This class compares two dates.
 * It compares its two arguments for order. Returns a negative integer, 
 * zero, or a positive integer as the first argument is less than, 
 * equal to, or greater than the second.
 */
public final class DateComparator implements java.util.Comparator<byte[]>, java.io.Serializable {

	/** logger */
	static GCUBELog logger = new GCUBELog(DateComparator.class);
	
	public DateComparator(){}
    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal to, 
     * or greater than the second.
     * @param obj1 - The first date to compare
     * @param obj2 - The second date to compare
     * @return - a negative integer, zero, or a positive integer as the first
     *           argument is less than, equal to, or greater than the second.
     */
    public int compare(byte[] obj1,
    		byte[] obj2) {
    	
    	CustomDate d1 = null;
        CustomDate d2 = null;
        try{
        	d1 = CustomDate.toCustomDate(obj1);
        	d2 = CustomDate.toCustomDate(obj2);
        }catch(Exception e){
        	logger.error("Error in date (De)Serialization.", e);
        }
        //            System.out.println("The class of " + d1.compareTo(d2));
        return d1.compareTo(d2);
    }
}
